package me.snowdrop.istio.mixer.adapter.statsd;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class StatsdListBuilder extends StatsdListFluentImpl<StatsdListBuilder> implements VisitableBuilder<StatsdList,StatsdListBuilder>{

    StatsdListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public StatsdListBuilder(){
            this(true);
    }
    public StatsdListBuilder(Boolean validationEnabled){
            this(new StatsdList(), validationEnabled);
    }
    public StatsdListBuilder(StatsdListFluent<?> fluent){
            this(fluent, true);
    }
    public StatsdListBuilder(StatsdListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new StatsdList(), validationEnabled);
    }
    public StatsdListBuilder(StatsdListFluent<?> fluent,StatsdList instance){
            this(fluent, instance, true);
    }
    public StatsdListBuilder(StatsdListFluent<?> fluent,StatsdList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public StatsdListBuilder(StatsdList instance){
            this(instance,true);
    }
    public StatsdListBuilder(StatsdList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public StatsdListBuilder(Validator validator){
            this(new StatsdList(), true);
    }
    public StatsdListBuilder(StatsdListFluent<?> fluent,StatsdList instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public StatsdListBuilder(StatsdList instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public StatsdList build(){
            StatsdList buildable = new StatsdList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StatsdListBuilder that = (StatsdListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
