package me.snowdrop.istio.mixer.adapter.stdio;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class StdioBuilder extends StdioFluentImpl<StdioBuilder> implements VisitableBuilder<Stdio,StdioBuilder>{

    StdioFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public StdioBuilder(){
            this(true);
    }
    public StdioBuilder(Boolean validationEnabled){
            this(new Stdio(), validationEnabled);
    }
    public StdioBuilder(StdioFluent<?> fluent){
            this(fluent, true);
    }
    public StdioBuilder(StdioFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Stdio(), validationEnabled);
    }
    public StdioBuilder(StdioFluent<?> fluent,Stdio instance){
            this(fluent, instance, true);
    }
    public StdioBuilder(StdioFluent<?> fluent,Stdio instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public StdioBuilder(Stdio instance){
            this(instance,true);
    }
    public StdioBuilder(Stdio instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public StdioBuilder(Validator validator){
            this(new Stdio(), true);
    }
    public StdioBuilder(StdioFluent<?> fluent,Stdio instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public StdioBuilder(Stdio instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Stdio build(){
            Stdio buildable = new Stdio(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StdioBuilder that = (StdioBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
