package me.snowdrop.istio.mixer.template.authorization;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ActionBuilder extends me.snowdrop.istio.mixer.template.authorization.ActionFluentImpl<me.snowdrop.istio.mixer.template.authorization.ActionBuilder> implements VisitableBuilder<me.snowdrop.istio.mixer.template.authorization.Action,me.snowdrop.istio.mixer.template.authorization.ActionBuilder>{

    me.snowdrop.istio.mixer.template.authorization.ActionFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ActionBuilder(){
            this(true);
    }
    public ActionBuilder(Boolean validationEnabled){
            this(new Action(), validationEnabled);
    }
    public ActionBuilder(me.snowdrop.istio.mixer.template.authorization.ActionFluent<?> fluent){
            this(fluent, true);
    }
    public ActionBuilder(me.snowdrop.istio.mixer.template.authorization.ActionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Action(), validationEnabled);
    }
    public ActionBuilder(me.snowdrop.istio.mixer.template.authorization.ActionFluent<?> fluent,me.snowdrop.istio.mixer.template.authorization.Action instance){
            this(fluent, instance, true);
    }
    public ActionBuilder(me.snowdrop.istio.mixer.template.authorization.ActionFluent<?> fluent,me.snowdrop.istio.mixer.template.authorization.Action instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMethod(instance.getMethod()); 
            fluent.withNamespace(instance.getNamespace()); 
            fluent.withPath(instance.getPath()); 
            fluent.withProperties(instance.getProperties()); 
            fluent.withService(instance.getService()); 
            this.validationEnabled = validationEnabled; 
    }
    public ActionBuilder(me.snowdrop.istio.mixer.template.authorization.Action instance){
            this(instance,true);
    }
    public ActionBuilder(me.snowdrop.istio.mixer.template.authorization.Action instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMethod(instance.getMethod()); 
            this.withNamespace(instance.getNamespace()); 
            this.withPath(instance.getPath()); 
            this.withProperties(instance.getProperties()); 
            this.withService(instance.getService()); 
            this.validationEnabled = validationEnabled; 
    }
    public ActionBuilder(Validator validator){
            this(new Action(), true);
    }
    public ActionBuilder(me.snowdrop.istio.mixer.template.authorization.ActionFluent<?> fluent,me.snowdrop.istio.mixer.template.authorization.Action instance,Validator validator){
            this.fluent = fluent; 
            fluent.withMethod(instance.getMethod()); 
            fluent.withNamespace(instance.getNamespace()); 
            fluent.withPath(instance.getPath()); 
            fluent.withProperties(instance.getProperties()); 
            fluent.withService(instance.getService()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ActionBuilder(me.snowdrop.istio.mixer.template.authorization.Action instance,Validator validator){
            this.fluent = this; 
            this.withMethod(instance.getMethod()); 
            this.withNamespace(instance.getNamespace()); 
            this.withPath(instance.getPath()); 
            this.withProperties(instance.getProperties()); 
            this.withService(instance.getService()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public me.snowdrop.istio.mixer.template.authorization.Action build(){
            Action buildable = new Action(fluent.getMethod(),fluent.getNamespace(),fluent.getPath(),fluent.getProperties(),fluent.getService());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ActionBuilder that = (ActionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
