package me.snowdrop.istio.mixer.template.edge;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class EdgeListFluentImpl<A extends EdgeListFluent<A>> extends BaseFluent<A> implements EdgeListFluent<A>{

    private String apiVersion;
    private List<EdgeBuilder> items;
    private String kind;
    private ListMeta metadata;

    public EdgeListFluentImpl(){
    }
    public EdgeListFluentImpl(EdgeList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A addToItems(int index,Edge item){
            if (this.items == null) {this.items = new ArrayList<EdgeBuilder>();}
            EdgeBuilder builder = new EdgeBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,Edge item){
            if (this.items == null) {this.items = new ArrayList<EdgeBuilder>();}
            EdgeBuilder builder = new EdgeBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(Edge... items){
            if (this.items == null) {this.items = new ArrayList<EdgeBuilder>();}
            for (Edge item : items) {EdgeBuilder builder = new EdgeBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<Edge> items){
            if (this.items == null) {this.items = new ArrayList<EdgeBuilder>();}
            for (Edge item : items) {EdgeBuilder builder = new EdgeBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(Edge... items){
            for (Edge item : items) {EdgeBuilder builder = new EdgeBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<Edge> items){
            for (Edge item : items) {EdgeBuilder builder = new EdgeBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Edge> getItems(){
            return build(items);
    }

    public List<Edge> buildItems(){
            return build(items);
    }

    public Edge buildItem(int index){
            return this.items.get(index).build();
    }

    public Edge buildFirstItem(){
            return this.items.get(0).build();
    }

    public Edge buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public Edge buildMatchingItem(Predicate<EdgeBuilder> predicate){
            for (EdgeBuilder item: items) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withItems(List<Edge> items){
            if (this.items != null) { _visitables.removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<EdgeBuilder>(); for (Edge item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(Edge... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (Edge item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public EdgeListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public EdgeListFluent.ItemsNested<A> addNewItemLike(Edge item){
            return new ItemsNestedImpl(-1, item);
    }

    public EdgeListFluent.ItemsNested<A> setNewItemLike(int index,Edge item){
            return new ItemsNestedImpl(index, item);
    }

    public EdgeListFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public EdgeListFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public EdgeListFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public EdgeListFluent.ItemsNested<A> editMatchingItem(Predicate<EdgeBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public ListMeta getMetadata(){
            return this.metadata;
    }

    public A withMetadata(ListMeta metadata){
            this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public A withNewMetadata(String _continue,String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(_continue, resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EdgeListFluentImpl that = (EdgeListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends EdgeFluentImpl<EdgeListFluent.ItemsNested<N>> implements EdgeListFluent.ItemsNested<N>,Nested<N>{

            private final EdgeBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,Edge item){
                    this.index = index;
                    this.builder = new EdgeBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new EdgeBuilder(this);
            }
    
    public N and(){
            return (N) EdgeListFluentImpl.this.setToItems(index, builder.build());
    }
    public N endItem(){
            return and();
    }

}


}
