/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.fluentd;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import me.snowdrop.istio.mixer.adapter.fluentd.FluentdSpec;
import me.snowdrop.istio.mixer.adapter.fluentd.FluentdSpecFluent;
import me.snowdrop.istio.mixer.adapter.fluentd.FluentdSpecFluentImpl;

public class FluentdSpecBuilder
extends FluentdSpecFluentImpl<FluentdSpecBuilder>
implements VisitableBuilder<FluentdSpec, FluentdSpecBuilder> {
    FluentdSpecFluent<?> fluent;
    Boolean validationEnabled;

    public FluentdSpecBuilder() {
        this(true);
    }

    public FluentdSpecBuilder(Boolean validationEnabled) {
        this(new FluentdSpec(), validationEnabled);
    }

    public FluentdSpecBuilder(FluentdSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public FluentdSpecBuilder(FluentdSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new FluentdSpec(), validationEnabled);
    }

    public FluentdSpecBuilder(FluentdSpecFluent<?> fluent, FluentdSpec instance) {
        this(fluent, instance, true);
    }

    public FluentdSpecBuilder(FluentdSpecFluent<?> fluent, FluentdSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddress(instance.getAddress());
        fluent.withInstanceBufferSize(instance.getInstanceBufferSize());
        fluent.withIntegerDuration(instance.getIntegerDuration());
        fluent.withMaxBatchSizeBytes(instance.getMaxBatchSizeBytes());
        fluent.withPushIntervalDuration(instance.getPushIntervalDuration());
        fluent.withPushTimeoutDuration(instance.getPushTimeoutDuration());
        this.validationEnabled = validationEnabled;
    }

    public FluentdSpecBuilder(FluentdSpec instance) {
        this(instance, (Boolean)true);
    }

    public FluentdSpecBuilder(FluentdSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddress(instance.getAddress());
        this.withInstanceBufferSize(instance.getInstanceBufferSize());
        this.withIntegerDuration(instance.getIntegerDuration());
        this.withMaxBatchSizeBytes(instance.getMaxBatchSizeBytes());
        this.withPushIntervalDuration(instance.getPushIntervalDuration());
        this.withPushTimeoutDuration(instance.getPushTimeoutDuration());
        this.validationEnabled = validationEnabled;
    }

    public FluentdSpec build() {
        FluentdSpec buildable = new FluentdSpec(this.fluent.getAddress(), this.fluent.getInstanceBufferSize(), this.fluent.isIntegerDuration(), this.fluent.getMaxBatchSizeBytes(), this.fluent.getPushIntervalDuration(), this.fluent.getPushTimeoutDuration());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FluentdSpecBuilder that = (FluentdSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

