/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.istio.mixer.adapter.memquota;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import me.snowdrop.istio.mixer.adapter.memquota.MemquotaSpec;
import me.snowdrop.istio.mixer.adapter.memquota.MemquotaSpecFluent;
import me.snowdrop.istio.mixer.adapter.memquota.Quota;
import me.snowdrop.istio.mixer.adapter.memquota.QuotaBuilder;
import me.snowdrop.istio.mixer.adapter.memquota.QuotaFluentImpl;

public class MemquotaSpecFluentImpl<A extends MemquotaSpecFluent<A>>
extends BaseFluent<A>
implements MemquotaSpecFluent<A> {
    private Integer minDeduplicationDuration;
    private List<QuotaBuilder> quotas;

    public MemquotaSpecFluentImpl() {
    }

    public MemquotaSpecFluentImpl(MemquotaSpec instance) {
        this.withMinDeduplicationDuration(instance.getMinDeduplicationDuration());
        this.withQuotas(instance.getQuotas());
    }

    @Override
    public Integer getMinDeduplicationDuration() {
        return this.minDeduplicationDuration;
    }

    @Override
    public A withMinDeduplicationDuration(Integer minDeduplicationDuration) {
        this.minDeduplicationDuration = minDeduplicationDuration;
        return (A)this;
    }

    @Override
    public Boolean hasMinDeduplicationDuration() {
        return this.minDeduplicationDuration != null;
    }

    @Override
    public A addToQuotas(int index, Quota item) {
        if (this.quotas == null) {
            this.quotas = new ArrayList<QuotaBuilder>();
        }
        QuotaBuilder builder = new QuotaBuilder(item);
        this._visitables.get((Object)"quotas").add(index >= 0 ? index : this._visitables.get((Object)"quotas").size(), builder);
        this.quotas.add(index >= 0 ? index : this.quotas.size(), builder);
        return (A)this;
    }

    @Override
    public A setToQuotas(int index, Quota item) {
        if (this.quotas == null) {
            this.quotas = new ArrayList<QuotaBuilder>();
        }
        QuotaBuilder builder = new QuotaBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"quotas").size()) {
            this._visitables.get((Object)"quotas").add(builder);
        } else {
            this._visitables.get((Object)"quotas").set(index, builder);
        }
        if (index < 0 || index >= this.quotas.size()) {
            this.quotas.add(builder);
        } else {
            this.quotas.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToQuotas(Quota ... items) {
        if (this.quotas == null) {
            this.quotas = new ArrayList<QuotaBuilder>();
        }
        for (Quota item : items) {
            QuotaBuilder builder = new QuotaBuilder(item);
            this._visitables.get((Object)"quotas").add(builder);
            this.quotas.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToQuotas(Collection<Quota> items) {
        if (this.quotas == null) {
            this.quotas = new ArrayList<QuotaBuilder>();
        }
        for (Quota item : items) {
            QuotaBuilder builder = new QuotaBuilder(item);
            this._visitables.get((Object)"quotas").add(builder);
            this.quotas.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromQuotas(Quota ... items) {
        for (Quota item : items) {
            QuotaBuilder builder = new QuotaBuilder(item);
            this._visitables.get((Object)"quotas").remove(builder);
            if (this.quotas == null) continue;
            this.quotas.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromQuotas(Collection<Quota> items) {
        for (Quota item : items) {
            QuotaBuilder builder = new QuotaBuilder(item);
            this._visitables.get((Object)"quotas").remove(builder);
            if (this.quotas == null) continue;
            this.quotas.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromQuotas(Predicate<QuotaBuilder> predicate) {
        if (this.quotas == null) {
            return (A)this;
        }
        Iterator<QuotaBuilder> each = this.quotas.iterator();
        List visitables = this._visitables.get((Object)"quotas");
        while (each.hasNext()) {
            QuotaBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Quota> getQuotas() {
        return MemquotaSpecFluentImpl.build(this.quotas);
    }

    @Override
    public List<Quota> buildQuotas() {
        return MemquotaSpecFluentImpl.build(this.quotas);
    }

    @Override
    public Quota buildQuota(int index) {
        return this.quotas.get(index).build();
    }

    @Override
    public Quota buildFirstQuota() {
        return this.quotas.get(0).build();
    }

    @Override
    public Quota buildLastQuota() {
        return this.quotas.get(this.quotas.size() - 1).build();
    }

    @Override
    public Quota buildMatchingQuota(Predicate<QuotaBuilder> predicate) {
        for (QuotaBuilder item : this.quotas) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingQuota(Predicate<QuotaBuilder> predicate) {
        for (QuotaBuilder item : this.quotas) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withQuotas(List<Quota> quotas) {
        if (this.quotas != null) {
            this._visitables.get((Object)"quotas").removeAll(this.quotas);
        }
        if (quotas != null) {
            this.quotas = new ArrayList<QuotaBuilder>();
            for (Quota item : quotas) {
                this.addToQuotas(item);
            }
        } else {
            this.quotas = null;
        }
        return (A)this;
    }

    @Override
    public A withQuotas(Quota ... quotas) {
        if (this.quotas != null) {
            this.quotas.clear();
        }
        if (quotas != null) {
            for (Quota item : quotas) {
                this.addToQuotas(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasQuotas() {
        return this.quotas != null && !this.quotas.isEmpty();
    }

    @Override
    public MemquotaSpecFluent.QuotasNested<A> addNewQuota() {
        return new QuotasNestedImpl();
    }

    @Override
    public MemquotaSpecFluent.QuotasNested<A> addNewQuotaLike(Quota item) {
        return new QuotasNestedImpl(-1, item);
    }

    @Override
    public MemquotaSpecFluent.QuotasNested<A> setNewQuotaLike(int index, Quota item) {
        return new QuotasNestedImpl(index, item);
    }

    @Override
    public MemquotaSpecFluent.QuotasNested<A> editQuota(int index) {
        if (this.quotas.size() <= index) {
            throw new RuntimeException("Can't edit quotas. Index exceeds size.");
        }
        return this.setNewQuotaLike(index, this.buildQuota(index));
    }

    @Override
    public MemquotaSpecFluent.QuotasNested<A> editFirstQuota() {
        if (this.quotas.size() == 0) {
            throw new RuntimeException("Can't edit first quotas. The list is empty.");
        }
        return this.setNewQuotaLike(0, this.buildQuota(0));
    }

    @Override
    public MemquotaSpecFluent.QuotasNested<A> editLastQuota() {
        int index = this.quotas.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last quotas. The list is empty.");
        }
        return this.setNewQuotaLike(index, this.buildQuota(index));
    }

    @Override
    public MemquotaSpecFluent.QuotasNested<A> editMatchingQuota(Predicate<QuotaBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.quotas.size(); ++i) {
            if (!predicate.apply((Object)this.quotas.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching quotas. No match found.");
        }
        return this.setNewQuotaLike(index, this.buildQuota(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemquotaSpecFluentImpl that = (MemquotaSpecFluentImpl)o;
        if (this.minDeduplicationDuration != null ? !this.minDeduplicationDuration.equals(that.minDeduplicationDuration) : that.minDeduplicationDuration != null) {
            return false;
        }
        return !(this.quotas != null ? !this.quotas.equals(that.quotas) : that.quotas != null);
    }

    public class QuotasNestedImpl<N>
    extends QuotaFluentImpl<MemquotaSpecFluent.QuotasNested<N>>
    implements MemquotaSpecFluent.QuotasNested<N>,
    Nested<N> {
        private final QuotaBuilder builder;
        private final int index;

        QuotasNestedImpl(int index, Quota item) {
            this.index = index;
            this.builder = new QuotaBuilder(this, item);
        }

        QuotasNestedImpl() {
            this.index = -1;
            this.builder = new QuotaBuilder(this);
        }

        @Override
        public N and() {
            return (N)MemquotaSpecFluentImpl.this.setToQuotas(this.index, this.builder.build());
        }

        @Override
        public N endQuota() {
            return this.and();
        }
    }
}

