/*
 * Decompiled with CFR 0.152.
 */
package vagrant.impl.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import vagrant.api.CommandIOListener;

public class VagrantCli {
    private static final Logger LOG = Logger.getLogger(VagrantCli.class.getName());
    private final File path;
    private final List<String> args;
    private final CommandIOListener ioListener;

    public VagrantCli(File path, CommandIOListener ioListener) {
        if (!path.exists()) {
            throw new IllegalStateException("Vagrant machine path " + path + " doesn't exist.");
        }
        this.path = path;
        this.ioListener = ioListener;
        this.args = new ArrayList<String>();
        this.args.add("vagrant");
    }

    public VagrantCli arg(String arg) {
        this.args.add(arg);
        return this;
    }

    public VagrantCli machineReadable() {
        return this.arg("--machine-readable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            return this.executeSequential();
        }
    }

    public String executeSequential() {
        long start = System.currentTimeMillis();
        String logArgs = this.args.toString();
        LOG.fine(start + " - VagrantCli: execute " + logArgs);
        this.ioListener.onInput(logArgs);
        this.ioListener.onInput(null);
        ProcessBuilder pb = new ProcessBuilder(this.args);
        pb.directory(this.path);
        pb.redirectErrorStream();
        try {
            Process p = pb.start();
            p.getOutputStream().close();
            String out = this.readFully(p.getInputStream());
            if (p.waitFor() != 0) {
                throw new IllegalStateException("Invaid return code " + p.exitValue() + ".\n" + out);
            }
            long end = System.currentTimeMillis();
            LOG.fine(end + " (" + (end - start) + ") - \n" + out);
            return out;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed while executing " + logArgs, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while executing " + logArgs, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFully(InputStream in) throws IOException {
        InputStreamReader r = new InputStreamReader(in);
        StringBuilder str = new StringBuilder();
        char[] buff = new char[4096];
        try {
            int read;
            while ((read = ((Reader)r).read(buff, 0, buff.length)) != -1) {
                String output = new String(buff, 0, read);
                str.append(output);
                this.ioListener.onOutput(output);
            }
        }
        finally {
            this.ioListener.onOutput(null);
        }
        ((Reader)r).close();
        return str.toString();
    }
}

