/*
 * Decompiled with CFR 0.152.
 */
package sbt_inc;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import sbt.internal.inc.PlainVirtualFile;
import sbt_inc.SbtIncrementalCompiler;
import xsbti.Logger;
import xsbti.VirtualFile;
import xsbti.compile.AnalysisContents;
import xsbti.compile.AnalysisStore;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.CompileOptions;
import xsbti.compile.CompileOrder;
import xsbti.compile.CompileResult;
import xsbti.compile.Compilers;
import xsbti.compile.IncrementalCompiler;
import xsbti.compile.Inputs;
import xsbti.compile.MiniSetup;
import xsbti.compile.PreviousResult;
import xsbti.compile.Setup;

public final class InProcessSbtIncrementalCompiler
implements SbtIncrementalCompiler {
    private final Compilers compilers;
    private final AnalysisStore analysisStore;
    private final Setup setup;
    private final IncrementalCompiler compiler;
    private final CompileOrder compileOrder;
    private final Logger sbtLogger;

    public InProcessSbtIncrementalCompiler(Compilers compilers, AnalysisStore analysisStore, Setup setup, IncrementalCompiler compiler, CompileOrder compileOrder, Logger sbtLogger) {
        this.compilers = compilers;
        this.analysisStore = analysisStore;
        this.setup = setup;
        this.compiler = compiler;
        this.compileOrder = compileOrder;
        this.sbtLogger = sbtLogger;
    }

    @Override
    public void compile(Collection<File> classpathElements, Collection<File> sources, File classesDirectory, Collection<String> scalacOptions, Collection<String> javacOptions) {
        ArrayList<File> fullClasspathElements = new ArrayList<File>(classpathElements);
        fullClasspathElements.add(classesDirectory);
        CompileOptions options = CompileOptions.of((VirtualFile[])((VirtualFile[])fullClasspathElements.stream().map(file -> new PlainVirtualFile(file.toPath())).toArray(VirtualFile[]::new)), (VirtualFile[])((VirtualFile[])sources.stream().map(file -> new PlainVirtualFile(file.toPath())).toArray(VirtualFile[]::new)), (Path)classesDirectory.toPath(), (String[])scalacOptions.toArray(new String[0]), (String[])javacOptions.toArray(new String[0]), (int)100, pos -> pos, (CompileOrder)this.compileOrder, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        Inputs inputs = Inputs.of((Compilers)this.compilers, (CompileOptions)options, (Setup)this.setup, (PreviousResult)this.previousResult());
        CompileResult newResult = this.compiler.compile(inputs, this.sbtLogger);
        this.analysisStore.set(AnalysisContents.create((CompileAnalysis)newResult.analysis(), (MiniSetup)newResult.setup()));
    }

    private PreviousResult previousResult() {
        Optional analysisContents = this.analysisStore.get();
        if (analysisContents.isPresent()) {
            AnalysisContents analysisContents0 = (AnalysisContents)analysisContents.get();
            CompileAnalysis previousAnalysis = analysisContents0.getAnalysis();
            MiniSetup previousSetup = analysisContents0.getMiniSetup();
            return PreviousResult.of(Optional.of(previousAnalysis), Optional.of(previousSetup));
        }
        return PreviousResult.of(Optional.empty(), Optional.empty());
    }
}

