/*
 * Decompiled with CFR 0.152.
 */
package net.bitnine.agensgraph.graph;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class GraphId
extends PGobject
implements Serializable,
Cloneable {
    private long id;

    public GraphId() {
        this.setType("graphid");
    }

    public GraphId(long id) {
        this();
        long labid = id >> 48 & 0xFFFFL;
        long locid = id & 0xFFFFFFFFFFFFL;
        this.value = labid + "." + locid;
        this.id = id;
    }

    @Override
    public void setValue(String value) throws SQLException {
        String[] ids = value.split("\\.");
        if (ids.length != 2) {
            throw new PSQLException("Parsing graphid failed", PSQLState.DATA_ERROR);
        }
        super.setValue(value);
        long labid = Long.parseLong(ids[0]);
        long locid = Long.parseLong(ids[1]);
        this.id = labid << 48 | locid;
    }

    public long getId() {
        return this.id;
    }
}

