/*
 * Decompiled with CFR 0.152.
 */
package net.bitnine.agensgraph.graph;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import net.bitnine.agensgraph.graph.Edge;
import net.bitnine.agensgraph.graph.Vertex;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class Path
extends PGobject
implements Serializable,
Cloneable {
    private ArrayList<Vertex> vertices;
    private ArrayList<Edge> edges;

    public Path() {
        this.setType("graphpath");
    }

    @Override
    public void setValue(String value) throws SQLException {
        ArrayList<String> tokens = this.tokenize(value);
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (int i = 0; i < tokens.size(); ++i) {
            if (i % 2 == 0) {
                Vertex v = new Vertex();
                v.setValue(tokens.get(i));
                vertices.add(v);
                continue;
            }
            Edge e = new Edge();
            e.setValue(tokens.get(i));
            edges.add(e);
        }
        this.vertices = vertices;
        this.edges = edges;
        super.setValue(value);
    }

    private ArrayList<String> tokenize(String value) throws SQLException {
        int pos;
        ArrayList<String> tokens = new ArrayList<String>();
        int len = value.length() - 1;
        int start = pos;
        int depth = 0;
        boolean gid = false;
        block8: for (pos = 1; pos < len; ++pos) {
            char c = value.charAt(pos);
            switch (c) {
                case '\"': {
                    if (depth <= 0) continue block8;
                    boolean escape = false;
                    for (int i = pos + 1; i < len; ++i) {
                        c = value.charAt(i);
                        if (c == '\\') {
                            escape = !escape;
                            continue;
                        }
                        if (c == '\"') {
                            if (escape) {
                                escape = false;
                                continue;
                            }
                            pos = i;
                            continue block8;
                        }
                        escape = false;
                    }
                    continue block8;
                }
                case '[': {
                    if (depth != 0) continue block8;
                    gid = true;
                    continue block8;
                }
                case ']': {
                    if (depth != 0) continue block8;
                    gid = false;
                    continue block8;
                }
                case '{': {
                    ++depth;
                    continue block8;
                }
                case '}': {
                    if (--depth >= 0) continue block8;
                    throw new PSQLException("Parsing graphpath failed", PSQLState.DATA_ERROR);
                }
                case ',': {
                    if (depth != 0 || gid) continue block8;
                    tokens.add(value.substring(start, pos));
                    start = pos + 1;
                    continue block8;
                }
            }
        }
        tokens.add(value.substring(start, pos));
        return tokens;
    }

    public Iterable<Vertex> vertices() {
        return this.vertices;
    }

    public Iterable<Edge> edges() {
        return this.edges;
    }

    public int length() {
        return this.edges.size();
    }
}

