/*
 * Decompiled with CFR 0.152.
 */
package net.bitnine.agensgraph.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import net.bitnine.agensgraph.graph.Edge;
import net.bitnine.agensgraph.graph.GraphId;
import net.bitnine.agensgraph.graph.Path;
import net.bitnine.agensgraph.graph.Vertex;
import net.bitnine.agensgraph.jdbc.AgPreparedStatement;
import net.bitnine.agensgraph.jdbc.AgStatement;
import net.bitnine.agensgraph.util.Jsonb;
import org.postgresql.core.Parser;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class AgConnection
extends PgConnection {
    public AgConnection(HostSpec[] hostSpecs, String user, String database, Properties info, String url) throws SQLException {
        super(hostSpecs, user, database, info, url);
        this.addDataType("jsonb", Jsonb.class);
        this.addDataType("graphid", GraphId.class);
        this.addDataType("vertex", Vertex.class);
        this.addDataType("edge", Edge.class);
        this.addDataType("graphpath", Path.class);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement stmt = super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return new AgStatement(stmt);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement pstmt = super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return new AgPreparedStatement(pstmt);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (columnNames != null && columnNames.length == 0) {
            return this.prepareStatement(sql);
        }
        PreparedStatement pstmt = super.prepareStatement(sql, columnNames);
        return new AgPreparedStatement(pstmt);
    }

    public AgPreparedStatement prepareNamedParameterStatement(String queryString) throws SQLException {
        return this.prepareNamedParameterStatement(queryString, 1003, 1007);
    }

    public AgPreparedStatement prepareNamedParameterStatement(String queryString, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareNamedParameterStatement(queryString, resultSetType, resultSetConcurrency, this.getHoldability());
    }

    public AgPreparedStatement prepareNamedParameterStatement(String queryString, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        ArrayList<String> params = new ArrayList<String>();
        queryString = this.preprocessQueryString(queryString, params);
        PreparedStatement pstmt = super.prepareStatement(queryString, resultSetType, resultSetConcurrency, resultSetHoldability);
        return new AgPreparedStatement(pstmt, params);
    }

    public AgPreparedStatement prepareNamedParameterStatement(String queryString, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 1) {
            return this.prepareNamedParameterStatement(queryString);
        }
        return this.prepareNamedParameterStatement(queryString, (String[])null);
    }

    public AgPreparedStatement prepareNamedParameterStatement(String queryString, int[] columnIndexes) throws SQLException {
        if (columnIndexes != null && columnIndexes.length == 0) {
            return this.prepareNamedParameterStatement(queryString);
        }
        this.checkClosed();
        throw new PSQLException(GT.tr("Returning autogenerated keys is not supported.", new Object[0]), PSQLState.NOT_IMPLEMENTED);
    }

    public AgPreparedStatement prepareNamedParameterStatement(String queryString, String[] columnNames) throws SQLException {
        if (columnNames != null && columnNames.length == 0) {
            return this.prepareNamedParameterStatement(queryString);
        }
        this.checkClosed();
        ArrayList<String> params = new ArrayList<String>();
        queryString = this.preprocessQueryString(queryString, params);
        PreparedStatement pstmt = super.prepareStatement(queryString, columnNames);
        return new AgPreparedStatement(pstmt, params);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String preprocessQueryString(String queryString, ArrayList<String> params) throws SQLException {
        StringBuilder bld = new StringBuilder(queryString.length());
        char[] buf = queryString.toCharArray();
        int pos = 0;
        while (true) {
            block11: {
                if (pos >= buf.length) {
                    return bld.toString();
                }
                char c = buf[pos];
                int start = pos;
                switch (c) {
                    case '\'': {
                        pos = Parser.parseSingleQuotes(buf, start, true);
                        break;
                    }
                    case '\"': {
                        pos = Parser.parseDoubleQuotes(buf, start);
                        break;
                    }
                    case '-': {
                        pos = Parser.parseLineComment(buf, start);
                        break;
                    }
                    case '/': {
                        pos = Parser.parseBlockComment(buf, start);
                        break;
                    }
                    case '$': {
                        pos = Parser.parseDollarQuotes(buf, start);
                        if (pos > start || (pos = this.parseAndStoreNamedParameter(buf, start, params)) <= start) break;
                        bld.append('?');
                        break block11;
                    }
                }
                if (pos == start) {
                    bld.append(c);
                } else {
                    bld.append(buf, start, pos - start + 1);
                }
            }
            ++pos;
        }
    }

    private int parseAndStoreNamedParameter(char[] query, int offset, ArrayList<String> params) throws SQLException {
        if (offset + 1 >= query.length) {
            return offset;
        }
        if (offset > 0 && Parser.isIdentifierContChar(query[offset - 1])) {
            return offset;
        }
        int pos = offset + 1;
        if (!Parser.isDollarQuoteStartChar(query[pos])) {
            return offset;
        }
        ++pos;
        while (pos < query.length && Parser.isDollarQuoteContChar(query[pos])) {
            ++pos;
        }
        String paramName = new String(query, offset + 1, pos - (offset + 1));
        params.add(paramName);
        return pos - 1;
    }
}

