/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.tasks.io;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import net.coobird.thumbnailator.tasks.io.AbstractImageSource;
import net.coobird.thumbnailator.tasks.io.InputStreamImageSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLImageSource
extends AbstractImageSource<URL> {
    private final URL url;
    private final Proxy proxy;

    public URLImageSource(URL uRL) {
        if (uRL == null) {
            throw new NullPointerException("URL cannot be null.");
        }
        this.url = uRL;
        this.proxy = null;
    }

    public URLImageSource(String string) throws MalformedURLException {
        if (string == null) {
            throw new NullPointerException("URL cannot be null.");
        }
        this.url = new URL(string);
        this.proxy = null;
    }

    public URLImageSource(URL uRL, Proxy proxy) {
        if (uRL == null) {
            throw new NullPointerException("URL cannot be null.");
        }
        if (proxy == null) {
            throw new NullPointerException("Proxy cannot be null.");
        }
        this.url = uRL;
        this.proxy = proxy;
    }

    public URLImageSource(String string, Proxy proxy) throws MalformedURLException {
        if (string == null) {
            throw new NullPointerException("URL cannot be null.");
        }
        if (proxy == null) {
            throw new NullPointerException("Proxy cannot be null.");
        }
        this.url = new URL(string);
        this.proxy = proxy;
    }

    @Override
    public BufferedImage read() throws IOException {
        BufferedImage bufferedImage;
        InputStream inputStream;
        try {
            inputStream = this.proxy != null ? this.url.openConnection(this.proxy).getInputStream() : this.url.openStream();
        }
        catch (IOException iOException) {
            throw new IOException("Could not open connection to URL: " + this.url);
        }
        InputStreamImageSource inputStreamImageSource = new InputStreamImageSource(inputStream);
        inputStreamImageSource.setThumbnailParameter(this.param);
        try {
            bufferedImage = inputStreamImageSource.read();
        }
        catch (Exception exception) {
            throw new IOException("Could not obtain image from URL: " + this.url);
        }
        finally {
            inputStream.close();
        }
        this.inputFormatName = inputStreamImageSource.getInputFormatName();
        return this.finishedReading(bufferedImage);
    }

    @Override
    public URL getSource() {
        return this.url;
    }

    public Proxy getProxy() {
        return this.proxy;
    }
}

