/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.equities.marketdata;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.finmath.equities.marketdata.AffineDividend;
import net.finmath.equities.marketdata.FlatYieldCurve;

public class AffineDividendStream {
    private final AffineDividend[] dividendStream;

    public AffineDividendStream(AffineDividend[] dividendStream) {
        List<AffineDividend> diviList = Arrays.asList(dividendStream);
        diviList.sort(Comparator.comparing(pt -> pt.getDate()));
        this.dividendStream = diviList.toArray(new AffineDividend[0]);
    }

    public ArrayList<LocalDate> getDividendDates() {
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        for (AffineDividend divi : this.dividendStream) {
            dates.add(divi.getDate());
        }
        return dates;
    }

    public double getDividend(LocalDate date, double stockPrice) {
        for (AffineDividend divi : this.dividendStream) {
            if (divi.getDate() != date) continue;
            return divi.getDividend(stockPrice);
        }
        return 0.0;
    }

    public double getProportionalDividendFactor(LocalDate date) {
        for (AffineDividend divi : this.dividendStream) {
            if (divi.getDate() != date) continue;
            return divi.getProportionalDividendFactor();
        }
        return 1.0;
    }

    public double getCashDividend(LocalDate date) {
        for (AffineDividend divi : this.dividendStream) {
            if (divi.getDate() != date) continue;
            return divi.getCashDividend();
        }
        return 0.0;
    }

    public static AffineDividendStream getAffineDividendsFromCashDividends(AffineDividendStream cashDividends, HashMap<LocalDate, Double> transformationFactors, LocalDate valDate, double spot, FlatYieldCurve repoCurve) {
        ArrayList<LocalDate> dates = cashDividends.getDividendDates();
        ArrayList<AffineDividend> affineDividends = new ArrayList<AffineDividend>();
        for (LocalDate date : dates) {
            if (date.isBefore(valDate)) continue;
            assert (cashDividends.getProportionalDividendFactor(date) == 0.0) : "Proportional dividend different from zero for date " + date;
            double cashDividend = cashDividends.getCashDividend(date);
            double fwd = spot;
            for (LocalDate otherDate : dates) {
                if (!otherDate.isBefore(date) || otherDate.isBefore(valDate)) continue;
                fwd -= cashDividends.getCashDividend(otherDate) * repoCurve.getForwardDiscountFactor(valDate, otherDate);
            }
            double q = transformationFactors.get(date) * cashDividend * repoCurve.getForwardDiscountFactor(valDate, date) / fwd;
            affineDividends.add(new AffineDividend(date, (1.0 - transformationFactors.get(date)) * cashDividend, q));
        }
        return new AffineDividendStream(affineDividends.toArray(new AffineDividend[0]));
    }
}

