/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.equities.marketdata;

import java.time.LocalDate;
import net.finmath.time.daycount.DayCountConvention;

public class FlatYieldCurve {
    private final LocalDate curveDate;
    private final double rate;
    private final DayCountConvention dayCounter;

    public FlatYieldCurve(LocalDate curveDate, double rate, DayCountConvention dayCounter) {
        this.curveDate = curveDate;
        this.rate = rate;
        this.dayCounter = dayCounter;
    }

    public double getRate(double maturity) {
        assert (maturity >= 0.0) : "maturity must be positive";
        return this.rate;
    }

    public double getRate(LocalDate date) {
        return this.getRate(this.dayCounter.getDaycountFraction(this.curveDate, date));
    }

    public double getDiscountFactor(double maturity) {
        assert (maturity >= 0.0) : "maturity must be positive";
        return Math.exp(-maturity * this.rate);
    }

    public double getForwardDiscountFactor(double start, double expiry) {
        assert (start >= 0.0) : "start must be positive";
        assert (expiry >= start) : "start must be before expiry";
        return this.getDiscountFactor(expiry) / this.getDiscountFactor(start);
    }

    public double getDiscountFactor(LocalDate date) {
        return this.getDiscountFactor(this.dayCounter.getDaycountFraction(this.curveDate, date));
    }

    public double getForwardDiscountFactor(LocalDate startDate, LocalDate endDate) {
        assert (!startDate.isBefore(this.curveDate)) : "start date must be after curve date";
        assert (!endDate.isBefore(startDate)) : "end date must be after start date";
        return this.getDiscountFactor(endDate) / this.getDiscountFactor(startDate);
    }
}

