/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.equities.models;

import java.util.function.Function;
import net.finmath.functions.NormalDistribution;

public final class Black76Model {
    private Black76Model() {
    }

    public static double optionPrice(double forward, double optionStrike, double optionMaturity, double volatility, boolean isCall, double discountFactor) {
        double valueAnalytic;
        double callFactor;
        double d = callFactor = isCall ? 1.0 : -1.0;
        if (optionMaturity < 0.0) {
            valueAnalytic = 0.0;
        } else if (volatility == 0.0 || optionMaturity == 0.0) {
            valueAnalytic = Math.max(callFactor * (forward - optionStrike), 0.0);
        } else if (volatility == Double.POSITIVE_INFINITY) {
            valueAnalytic = isCall ? forward : optionStrike;
        } else {
            double dPlus = (Math.log(forward / optionStrike) + 0.5 * volatility * volatility * optionMaturity) / (volatility * Math.sqrt(optionMaturity));
            double dMinus = dPlus - volatility * Math.sqrt(optionMaturity);
            valueAnalytic = callFactor * (forward * NormalDistribution.cumulativeDistribution(callFactor * dPlus) - optionStrike * NormalDistribution.cumulativeDistribution(callFactor * dMinus));
        }
        return valueAnalytic * discountFactor;
    }

    public static double optionDelta(double forward, double optionStrike, double optionMaturity, double volatility, boolean isCall, double discountFactor) {
        double valueAnalytic;
        double callFactor;
        double d = callFactor = isCall ? 1.0 : -1.0;
        if (optionMaturity < 0.0) {
            valueAnalytic = 0.0;
        } else if (volatility == 0.0 || optionMaturity == 0.0) {
            valueAnalytic = forward == optionStrike ? 0.5 : (callFactor * (forward - optionStrike) > 0.0 ? callFactor : 0.0);
        } else if (volatility == Double.POSITIVE_INFINITY) {
            valueAnalytic = isCall ? 1.0 : 0.0;
        } else {
            double dPlus = (Math.log(forward / optionStrike) + 0.5 * volatility * volatility * optionMaturity) / (volatility * Math.sqrt(optionMaturity));
            valueAnalytic = callFactor * NormalDistribution.cumulativeDistribution(callFactor * dPlus);
        }
        return valueAnalytic * discountFactor;
    }

    public static double optionVega(double forward, double optionStrike, double optionMaturity, double volatility, boolean isCall, double discountFactor) {
        double valueAnalytic;
        if (optionMaturity < 0.0) {
            valueAnalytic = 0.0;
        } else if (volatility == 0.0 || optionMaturity == 0.0) {
            valueAnalytic = 0.0;
        } else if (volatility == Double.POSITIVE_INFINITY) {
            valueAnalytic = 0.0;
        } else {
            double sqrtT = Math.sqrt(optionMaturity);
            double dPlus = (Math.log(forward / optionStrike) + 0.5 * volatility * volatility * optionMaturity) / (volatility * sqrtT);
            valueAnalytic = forward * sqrtT * NormalDistribution.density(dPlus);
        }
        return valueAnalytic * discountFactor;
    }

    public static double optionGamma(double forward, double optionStrike, double optionMaturity, double volatility, boolean isCall, double discountFactor) {
        double valueAnalytic;
        if (optionMaturity < 0.0) {
            valueAnalytic = 0.0;
        } else if (volatility == 0.0 || optionMaturity == 0.0) {
            valueAnalytic = 0.0;
        } else if (volatility == Double.POSITIVE_INFINITY) {
            valueAnalytic = 0.0;
        } else {
            double sDev = volatility * Math.sqrt(optionMaturity);
            double dPlus = (Math.log(forward / optionStrike) + 0.5 * volatility * volatility * optionMaturity) / sDev;
            valueAnalytic = NormalDistribution.density(dPlus) / forward / sDev;
        }
        return valueAnalytic * discountFactor;
    }

    public static double optionTheta(double forward, double optionStrike, double optionMaturity, double volatility, boolean isCall, double discountFactor, double discountRate) {
        double valueAnalytic = discountRate * Black76Model.optionPrice(forward, optionStrike, optionMaturity, volatility, isCall, discountFactor);
        return valueAnalytic -= 0.5 * forward * forward * volatility * volatility * Black76Model.optionGamma(forward, optionStrike, optionMaturity, volatility, isCall, discountFactor);
    }

    public static double optionImpliedVolatility(double forward, double optionStrike, double optionMaturity, double undiscountedPrice, boolean isCall) {
        double r;
        double bPrimeCentral1;
        double impliedSdev;
        double beta;
        double bMax;
        double x;
        double xTemp = Math.log(forward / optionStrike);
        double betaTemp = undiscountedPrice / Math.sqrt(forward * optionStrike);
        double bMaxTemp = Math.exp(0.5 * xTemp);
        if (isCall) {
            if (xTemp > 0.0) {
                x = -xTemp;
                bMax = Math.exp(0.5 * x);
                beta = betaTemp + 2.0 * Math.sinh(0.5 * x);
            } else {
                x = xTemp;
                beta = betaTemp;
                bMax = bMaxTemp;
            }
        } else if (xTemp >= 0.0) {
            x = -xTemp;
            beta = betaTemp;
            bMax = Math.exp(0.5 * x);
        } else {
            x = xTemp;
            beta = betaTemp + 2.0 * Math.sinh(0.5 * x);
            bMax = bMaxTemp;
        }
        assert (beta >= 0.0 && beta <= bMax) : "The price " + undiscountedPrice + "is not attainable in Black-Scholes given the other parameters provided.";
        if (x == 0.0) {
            return 2.0 * NormalDistribution.inverseCumulativeDistribution(0.5 * (beta + 1.0));
        }
        double sqrtPi = Math.sqrt(Math.PI * 2);
        double sigmaCentral = Math.sqrt(-2.0 * x);
        double d1Central = x / sigmaCentral;
        double d2Central = 0.5 * sigmaCentral;
        double bCentral = NormalDistribution.cumulativeDistribution(d1Central + d2Central) * bMax - NormalDistribution.cumulativeDistribution(d1Central - d2Central) / bMax;
        double bPrimeCentral = Math.exp(-0.5 * (d1Central * d1Central + d2Central * d2Central)) / sqrtPi;
        double sigmaLower = sigmaCentral - bCentral / bPrimeCentral;
        double d1Lower = x / sigmaLower;
        double d2Lower = 0.5 * sigmaLower;
        double bLower = NormalDistribution.cumulativeDistribution(d1Lower + d2Lower) * bMax - NormalDistribution.cumulativeDistribution(d1Lower - d2Lower) / bMax;
        double sigmaUpper = sigmaCentral + (bMax - bCentral) / bPrimeCentral;
        double d1Upper = x / sigmaUpper;
        double d2Upper = 0.5 * sigmaUpper;
        double bUpper = NormalDistribution.cumulativeDistribution(d1Upper + d2Upper) * bMax - NormalDistribution.cumulativeDistribution(d1Upper - d2Upper) / bMax;
        if (beta < bLower) {
            double sqrtThree = Math.sqrt(3.0);
            double twoPi = Math.PI * 2;
            double z = x / sigmaLower / sqrtThree;
            double normDistOfZ = NormalDistribution.cumulativeDistribution(z);
            double fOfZ = Math.PI * -2 * x * normDistOfZ * normDistOfZ * normDistOfZ / 3.0 / sqrtThree;
            double sigmaLowerSquare = sigmaLower * sigmaLower;
            double zSquare = z * z;
            double fPrime = Math.PI * 2 * zSquare * normDistOfZ * normDistOfZ * Math.exp(zSquare + sigmaLowerSquare / 8.0);
            double fPrime2 = Math.PI * zSquare * normDistOfZ * Math.exp(2.0 * zSquare + sigmaLowerSquare / 4.0) / 6.0 / sigmaLowerSquare / sigmaLower * (-8.0 * sqrtThree * sigmaLower * x + (3.0 * sigmaLowerSquare * (sigmaLowerSquare - 8.0) - 8.0 * x * x) * normDistOfZ / NormalDistribution.density(z));
            double r2 = (0.5 * fPrime2 * bLower + fPrime - 1.0) / (fPrime - fOfZ / bLower);
            double fRationalCubic = Black76Model.rationalCubicInterpol(beta, 0.0, bLower, 0.0, fOfZ, 1.0, fPrime, r2);
            impliedSdev = NormalDistribution.inverseCumulativeDistribution(sqrtThree * Math.pow(Math.abs(fRationalCubic / (Math.PI * 2) / x), 0.3333333333333333));
            impliedSdev = Math.abs(x / sqrtThree / impliedSdev);
        } else if (beta <= bCentral) {
            double bPrimeLower1 = Math.exp(0.5 * (d1Lower * d1Lower + d2Lower * d2Lower)) * sqrtPi;
            bPrimeCentral1 = 1.0 / bPrimeCentral;
            r = (bPrimeCentral1 - bPrimeLower1) / (bPrimeCentral1 - (sigmaCentral - sigmaLower) / (bCentral - bLower));
            impliedSdev = Black76Model.rationalCubicInterpol(beta, bLower, bCentral, sigmaLower, sigmaCentral, bPrimeLower1, bPrimeCentral1, r);
        } else if (beta <= bUpper) {
            double bPrimeUpper1 = Math.exp(0.5 * (d1Upper * d1Upper + d2Upper * d2Upper)) * sqrtPi;
            bPrimeCentral1 = 1.0 / bPrimeCentral;
            r = (bPrimeUpper1 - bPrimeCentral1) / ((sigmaUpper - sigmaCentral) / (bUpper - bCentral) - bPrimeCentral1);
            impliedSdev = Black76Model.rationalCubicInterpol(beta, bCentral, bUpper, sigmaCentral, sigmaUpper, bPrimeCentral1, bPrimeUpper1, r);
        } else {
            double f = NormalDistribution.cumulativeDistribution(-0.5 * sigmaUpper);
            double sigmaUpper2 = sigmaUpper * sigmaUpper;
            double xSigma = x * x / sigmaUpper2;
            double fPrime = -0.5 * Math.exp(0.5 * xSigma);
            double fPrime2 = Math.sqrt(1.5707963267948966) * xSigma / sigmaUpper * Math.exp(xSigma + sigmaUpper2 / 8.0);
            double h = bMax - bUpper;
            double r3 = (0.5 * fPrime2 * h - 0.5 - fPrime) / (-f / h - fPrime);
            double fRC = Black76Model.rationalCubicInterpol(beta, bUpper, bMax, f, 0.0, fPrime, -0.5, r3);
            impliedSdev = -2.0 * NormalDistribution.inverseCumulativeDistribution(fRC);
        }
        double bMaxHalf = 0.5 * bMax;
        double bTildeUpper = bUpper >= bMaxHalf ? bUpper : bMaxHalf;
        Function<Double, Double[]> BlackFunctionDerivatives = sigma -> {
            double d1 = x / sigma;
            double d2 = 0.5 * sigma;
            double d1Square = d1 * d1;
            double d2Square = d2 * d2;
            double b0 = NormalDistribution.cumulativeDistribution(d1 + d2) * bMax - NormalDistribution.cumulativeDistribution(d1 - d2) / bMax;
            double b1 = Math.exp(-0.5 * (d1Square + d2Square)) / sqrtPi;
            double b2 = d1Square / sigma - 0.25 * sigma;
            double b3 = b2 * b2 - 0.75 * d1Square / d2Square - 0.25;
            return new Double[]{b0, b1, b2, b3};
        };
        if (beta <= bLower) {
            Function<Double, Double> HouseholderStep = sigma -> {
                Double[] derivatives = (Double[])BlackFunctionDerivatives.apply((Double)sigma);
                double b0 = derivatives[0];
                double b1 = derivatives[1];
                double b2 = derivatives[2];
                double b3 = derivatives[3];
                double lnOfB = Math.log(b0);
                double bLnOfB = b0 * lnOfB;
                double bLnOfBSquare = bLnOfB * bLnOfB;
                double nu = bLnOfB * (1.0 - lnOfB / Math.log(beta)) / b1;
                double gamma = (b0 * b2 * lnOfB - b1 * (lnOfB + 2.0)) / bLnOfB;
                double delta = (bLnOfBSquare * b3 + 2.0 * b1 * b1 * (lnOfB * lnOfB + 3.0 * lnOfB + 3.0) - 3.0 * bLnOfB * b1 * b2 * (lnOfB + 2.0)) / bLnOfBSquare;
                return sigma + nu * (1.0 + 0.5 * nu * gamma) / (1.0 + nu * (gamma + delta * nu / 6.0));
            };
            impliedSdev = HouseholderStep.apply(impliedSdev);
            impliedSdev = HouseholderStep.apply(impliedSdev);
        } else if (beta <= bTildeUpper) {
            Function<Double, Double> HouseholderStep = sigma -> {
                Double[] deriv = (Double[])BlackFunctionDerivatives.apply((Double)sigma);
                double b0 = deriv[0] - beta;
                double b1 = deriv[1];
                double b2 = deriv[2];
                double b3 = deriv[3];
                double nu = -b0 / b1;
                double gamma = b2;
                double delta = b3;
                return sigma + nu * (1.0 + 0.5 * nu * gamma) / (1.0 + nu * (gamma + delta * nu / 6.0));
            };
            impliedSdev = HouseholderStep.apply(impliedSdev);
            impliedSdev = HouseholderStep.apply(impliedSdev);
        } else {
            Function<Double, Double> HouseholderStep = sigma -> {
                Double[] deriv = (Double[])BlackFunctionDerivatives.apply((Double)sigma);
                double b0 = deriv[0];
                double b1 = deriv[1];
                double b2 = deriv[2];
                double b3 = deriv[3];
                double bmaxb0 = bMax - b0;
                double nu = bmaxb0 * Math.log(bmaxb0 / (bMax - beta)) / b1;
                double gamma = b2 + b1 / bmaxb0;
                double delta = b3 + 3.0 * b1 * b2 / bmaxb0 + 2.0 * b1 * b1 / bmaxb0 / bmaxb0;
                return sigma + nu * (1.0 + 0.5 * nu * gamma) / (1.0 + nu * (gamma + delta * nu / 6.0));
            };
            impliedSdev = HouseholderStep.apply(impliedSdev);
            impliedSdev = HouseholderStep.apply(impliedSdev);
        }
        return impliedSdev / Math.sqrt(optionMaturity);
    }

    private static double rationalCubicInterpol(double xValue, double xLeft, double xRight, double fLeft, double fRight, double fPrimeLeft, double fPrimeRight, double blend) {
        double h = xRight - xLeft;
        double s = (xValue - xLeft) / h;
        double sMinusOne = 1.0 - s;
        return (fRight * s * s * s + (blend * fRight - h * fPrimeRight) * s * s * sMinusOne + (blend * fLeft + h * fPrimeLeft) * s * sMinusOne * sMinusOne + fLeft * sMinusOne * sMinusOne * sMinusOne) / (1.0 + (blend - 3.0) * s * sMinusOne);
    }
}

