/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.equities.models;

import java.time.LocalDate;
import java.util.ArrayList;
import net.finmath.equities.marketdata.VolatilityPoint;
import net.finmath.equities.models.EquityForwardStructure;
import net.finmath.equities.models.ShiftedVolatilitySurface;
import net.finmath.equities.models.VolatilitySurface;

public class FlatVolatilitySurface
implements VolatilitySurface,
ShiftedVolatilitySurface {
    private final double volatility;
    private final double volShift;

    public FlatVolatilitySurface(double volatility) {
        this(volatility, 0.0);
    }

    public FlatVolatilitySurface(double volatility, double volShift) {
        this.volatility = volatility;
        this.volShift = volShift;
    }

    @Override
    public ShiftedVolatilitySurface getShiftedSurface(double shift) {
        assert (this.volShift == 0.0) : "Surface is already shifted";
        return new FlatVolatilitySurface(this.volatility, shift);
    }

    @Override
    public double getShift() {
        return this.volShift;
    }

    @Override
    public double getVolatility(double strike, LocalDate expiryDate, EquityForwardStructure currentForwardStructure) {
        return this.volatility + this.volShift;
    }

    @Override
    public double getVolatility(double strike, double timeToMaturity, EquityForwardStructure currentForwardStructure) {
        return this.volatility + this.volShift;
    }

    @Override
    public double getLocalVolatility(double strike, LocalDate expiryDate, EquityForwardStructure currentForwardStructure, double strikeShift, double timeShift) {
        return this.volatility + this.volShift;
    }

    @Override
    public double getLocalVolatility(double logStrike, double timeToMaturity, EquityForwardStructure currentForwardStructure, double strikeShift, double timeShift) {
        return this.volatility + this.volShift;
    }

    @Override
    public void calibrate(EquityForwardStructure forwardStructure, ArrayList<VolatilityPoint> volaPoints) {
        assert (false) : "A flat surface cannot be calibrated";
    }
}

