/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.finitedifference.experimental;

import java.util.Arrays;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;

public class BlackScholesTheta {
    private final double volatility = 0.4;
    private final double riskFreeRate = 0.06;
    private final double optionStrike = 50.0;
    private final double optionMaturity = 1.0;
    private final int numberOfPointsNegative = -100;
    private final int numberOfPointsPositive = 20;
    private final int numTimesteps = 35;
    private final double dx = 0.06;
    private final double theta = 0.5;
    private final double gamma = 0.12 / Math.pow(0.4, 2.0);
    private final double alpha = -0.5 * (this.gamma - 1.0);
    private final double beta = -0.25 * Math.pow(this.gamma + 1.0, 2.0);
    private final double dtau = Math.pow(0.4, 2.0) * 1.0 / 70.0;
    private final double kappa = this.dtau / Math.pow(0.06, 2.0);

    private double V_T(double stockPrice) {
        return Math.max(stockPrice - 50.0, 0.0);
    }

    private double V_0(double stockPrice, double currentTime) {
        return 0.0;
    }

    private double V_inf(double stockPrice, double currentTime) {
        return stockPrice - 50.0 * Math.exp(-0.06 * (1.0 - currentTime));
    }

    private double f_s(double x) {
        return 50.0 * Math.exp(x);
    }

    private double f_t(double tau) {
        return 1.0 - 2.0 * tau / Math.pow(0.4, 2.0);
    }

    private double f(double value, double x, double tau) {
        return value / 50.0 * Math.exp(-this.alpha * x - this.beta * tau);
    }

    private double u_0(double x) {
        return this.f(this.V_T(this.f_s(x)), x, 0.0);
    }

    private double u_neg_inf(double x, double tau) {
        return this.f(this.V_0(this.f_s(x), this.f_t(tau)), x, tau);
    }

    private double u_pos_inf(double x, double tau) {
        return this.f(this.V_inf(this.f_s(x), this.f_t(tau)), x, tau);
    }

    public double[][] solve() {
        int len = 119;
        double[] x = new double[119];
        for (int i = 0; i < 119; ++i) {
            x[i] = -5.9399999999999995 + 0.06 * (double)i;
        }
        double[] tau = new double[36];
        for (int i = 0; i < 36; ++i) {
            tau[i] = (double)i * this.dtau;
        }
        double[][] C = new double[119][119];
        double[][] D = new double[119][119];
        for (int i = 0; i < 119; ++i) {
            for (int j = 0; j < 119; ++j) {
                if (i == j) {
                    C[i][j] = 1.0 + 1.0 * this.kappa;
                    D[i][j] = 1.0 - 1.0 * this.kappa;
                    continue;
                }
                if (i == j - 1 || i == j + 1) {
                    C[i][j] = -0.5 * this.kappa;
                    D[i][j] = 0.5 * this.kappa;
                    continue;
                }
                C[i][j] = 0.0;
                D[i][j] = 0.0;
            }
        }
        Array2DRowRealMatrix CMatrix = new Array2DRowRealMatrix(C);
        Array2DRowRealMatrix DMatrix = new Array2DRowRealMatrix(D);
        DecompositionSolver solver = new LUDecomposition((RealMatrix)CMatrix).getSolver();
        double[] b = new double[119];
        Arrays.fill(b, 0.0);
        double[] U = new double[119];
        for (int i = 0; i < U.length; ++i) {
            U[i] = this.u_0(x[i]);
        }
        RealMatrix UVector = MatrixUtils.createColumnRealMatrix((double[])U);
        for (int m = 0; m < 35; ++m) {
            b[0] = this.u_neg_inf(-6.0, tau[m]) * 0.5 * this.kappa + this.u_neg_inf(-6.0, tau[m + 1]) * 0.5 * this.kappa;
            b[118] = this.u_pos_inf(1.2, tau[m]) * 0.5 * this.kappa + this.u_pos_inf(1.2, tau[m + 1]) * 0.5 * this.kappa;
            RealMatrix bVector = MatrixUtils.createColumnRealMatrix((double[])b);
            RealMatrix constantsMatrix = DMatrix.multiply(UVector).add(bVector);
            UVector = solver.solve(constantsMatrix);
        }
        U = UVector.getColumn(0);
        double[] optionPrice = new double[119];
        double[] stockPrice = new double[119];
        for (int i = 0; i < 119; ++i) {
            optionPrice[i] = U[i] * 50.0 * Math.exp(this.alpha * x[i] + this.beta * tau[35]);
            stockPrice[i] = this.f_s(x[i]);
        }
        double[][] stockAndOptionPrice = new double[2][119];
        stockAndOptionPrice[0] = stockPrice;
        stockAndOptionPrice[1] = optionPrice;
        return stockAndOptionPrice;
    }
}

