/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.finitedifference.products;

import java.util.function.DoubleUnaryOperator;
import net.finmath.finitedifference.models.FiniteDifference1DBoundary;
import net.finmath.finitedifference.models.FiniteDifference1DModel;
import net.finmath.finitedifference.products.FiniteDifference1DProduct;

public class FDMEuropeanCallOption
implements FiniteDifference1DProduct,
FiniteDifference1DBoundary {
    private final double maturity;
    private final double strike;

    public FDMEuropeanCallOption(double optionMaturity, double optionStrike) {
        this.maturity = optionMaturity;
        this.strike = optionStrike;
    }

    @Override
    public double[][] getValue(double evaluationTime, FiniteDifference1DModel model) {
        FDMEuropeanCallOption boundary = this;
        return model.getValue(evaluationTime, this.maturity, new DoubleUnaryOperator(){

            @Override
            public double applyAsDouble(double assetValue) {
                return Math.max(assetValue - FDMEuropeanCallOption.this.strike, 0.0);
            }
        }, boundary);
    }

    @Override
    public double getValueAtLowerBoundary(FiniteDifference1DModel model, double currentTime, double stockPrice) {
        return 0.0;
    }

    @Override
    public double getValueAtUpperBoundary(FiniteDifference1DModel model, double currentTime, double stockPrice) {
        return stockPrice - this.strike * Math.exp(-model.getRiskFreeRate() * (this.maturity - currentTime));
    }
}

