/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.calibration.models;

import java.util.Arrays;
import net.finmath.fouriermethod.calibration.ScalarParameterInformation;
import net.finmath.fouriermethod.calibration.ScalarParameterInformationImplementation;
import net.finmath.fouriermethod.calibration.Unconstrained;
import net.finmath.fouriermethod.calibration.models.CalibratableProcess;
import net.finmath.fouriermethod.models.HestonModel;
import net.finmath.modelling.ModelDescriptor;
import net.finmath.modelling.descriptor.HestonModelDescriptor;

public class CalibratableHestonModel
implements CalibratableProcess {
    private final HestonModelDescriptor descriptor;
    private final ScalarParameterInformation volatilityInfo;
    private final ScalarParameterInformation thetaInfo;
    private final ScalarParameterInformation kappaInfo;
    private final ScalarParameterInformation xiInfo;
    private final ScalarParameterInformation rhoInfo;
    private final boolean applyFellerConstraint;
    private final double[] parameterUpperBounds;
    private final double[] parameterLowerBounds;

    public CalibratableHestonModel(HestonModelDescriptor descriptor) {
        this.descriptor = descriptor;
        this.volatilityInfo = new ScalarParameterInformationImplementation(true, new Unconstrained());
        this.thetaInfo = new ScalarParameterInformationImplementation(true, new Unconstrained());
        this.kappaInfo = new ScalarParameterInformationImplementation(true, new Unconstrained());
        this.xiInfo = new ScalarParameterInformationImplementation(true, new Unconstrained());
        this.rhoInfo = new ScalarParameterInformationImplementation(true, new Unconstrained());
        this.applyFellerConstraint = false;
        this.parameterUpperBounds = this.extractUpperBounds();
        this.parameterLowerBounds = this.extractLowerBounds();
    }

    public CalibratableHestonModel(HestonModelDescriptor descriptor, ScalarParameterInformation volatilityConstraint, ScalarParameterInformation thetaConstraint, ScalarParameterInformation kappaConstraint, ScalarParameterInformation xiConstraint, ScalarParameterInformation rhoConstraint, boolean applyFellerConstraint) {
        this.descriptor = descriptor;
        this.volatilityInfo = volatilityConstraint;
        this.thetaInfo = thetaConstraint;
        this.kappaInfo = kappaConstraint;
        this.xiInfo = xiConstraint;
        this.rhoInfo = rhoConstraint;
        this.applyFellerConstraint = applyFellerConstraint;
        this.parameterUpperBounds = this.extractUpperBounds();
        this.parameterLowerBounds = this.extractLowerBounds();
    }

    @Override
    public CalibratableHestonModel getCloneForModifiedParameters(double[] parameters) {
        double rho;
        double volatility = this.volatilityInfo.getIsParameterToCalibrate() ? this.volatilityInfo.getConstraint().apply(parameters[0]) : this.descriptor.getVolatility().doubleValue();
        double theta = this.thetaInfo.getIsParameterToCalibrate() ? this.thetaInfo.getConstraint().apply(parameters[1]) : this.descriptor.getTheta().doubleValue();
        double kappa = this.kappaInfo.getIsParameterToCalibrate() ? this.kappaInfo.getConstraint().apply(parameters[2]) : this.descriptor.getKappa().doubleValue();
        double xi = this.xiInfo.getIsParameterToCalibrate() ? this.xiInfo.getConstraint().apply(parameters[3]) : this.descriptor.getXi().doubleValue();
        double d = rho = this.rhoInfo.getIsParameterToCalibrate() ? this.rhoInfo.getConstraint().apply(parameters[4]) : this.descriptor.getRho().doubleValue();
        if (this.applyFellerConstraint && 2.0 * kappa * theta < xi * xi) {
            theta = xi * xi / (2.0 * kappa) + 1.0E-9;
        }
        HestonModelDescriptor newDescriptor = new HestonModelDescriptor(this.descriptor.getReferenceDate(), this.descriptor.getInitialValue(), this.descriptor.getDiscountCurveForForwardRate(), this.descriptor.getDiscountCurveForDiscountRate(), volatility, theta, kappa, xi, rho);
        return new CalibratableHestonModel(newDescriptor, this.volatilityInfo, this.thetaInfo, this.kappaInfo, this.xiInfo, this.rhoInfo, this.applyFellerConstraint);
    }

    @Override
    public ModelDescriptor getModelDescriptor() {
        return this.descriptor;
    }

    @Override
    public HestonModel getCharacteristicFunctionModel() {
        return new HestonModel((double)this.descriptor.getInitialValue(), this.descriptor.getDiscountCurveForForwardRate(), this.descriptor.getDiscountCurveForDiscountRate(), (double)this.descriptor.getVolatility(), (double)this.descriptor.getTheta(), (double)this.descriptor.getKappa(), (double)this.descriptor.getXi(), (double)this.descriptor.getRho());
    }

    @Override
    public double[] getParameterUpperBounds() {
        return this.parameterUpperBounds;
    }

    @Override
    public double[] getParameterLowerBounds() {
        return this.parameterLowerBounds;
    }

    private double[] extractUpperBounds() {
        double[] upperBounds = new double[5];
        double threshold = 1000000.0;
        upperBounds[0] = this.volatilityInfo.getConstraint().getUpperBound() > 1000000.0 ? 1000000.0 : this.volatilityInfo.getConstraint().getUpperBound();
        upperBounds[1] = this.thetaInfo.getConstraint().getUpperBound() > 1000000.0 ? 1000000.0 : this.thetaInfo.getConstraint().getUpperBound();
        upperBounds[2] = this.kappaInfo.getConstraint().getUpperBound() > 1000000.0 ? 1000000.0 : this.kappaInfo.getConstraint().getUpperBound();
        upperBounds[3] = this.xiInfo.getConstraint().getUpperBound() > 1000000.0 ? 1000000.0 : this.xiInfo.getConstraint().getUpperBound();
        upperBounds[4] = this.rhoInfo.getConstraint().getUpperBound() > 1000000.0 ? 1000000.0 : this.rhoInfo.getConstraint().getUpperBound();
        return upperBounds;
    }

    private double[] extractLowerBounds() {
        double[] upperBounds = new double[5];
        double threshold = -1000000.0;
        upperBounds[0] = this.volatilityInfo.getConstraint().getLowerBound() < -1000000.0 ? -1000000.0 : this.volatilityInfo.getConstraint().getLowerBound();
        upperBounds[1] = this.thetaInfo.getConstraint().getLowerBound() < -1000000.0 ? -1000000.0 : this.thetaInfo.getConstraint().getLowerBound();
        upperBounds[2] = this.kappaInfo.getConstraint().getLowerBound() < -1000000.0 ? -1000000.0 : this.kappaInfo.getConstraint().getLowerBound();
        upperBounds[3] = this.xiInfo.getConstraint().getLowerBound() < -1000000.0 ? -1000000.0 : this.xiInfo.getConstraint().getLowerBound();
        upperBounds[4] = this.rhoInfo.getConstraint().getLowerBound() < -1000000.0 ? -1000000.0 : this.rhoInfo.getConstraint().getLowerBound();
        return upperBounds;
    }

    public String toString() {
        return "CalibratableHestonModel [descriptor=" + this.descriptor + ", volatilityInfo=" + this.volatilityInfo + ", thetaInfo=" + this.thetaInfo + ", kappaInfo=" + this.kappaInfo + ", xiInfo=" + this.xiInfo + ", rhoInfo=" + this.rhoInfo + ", applyFellerConstraint=" + this.applyFellerConstraint + ", parameterUpperBounds=" + Arrays.toString(this.parameterUpperBounds) + ", parameterLowerBounds=" + Arrays.toString(this.parameterLowerBounds) + "]";
    }
}

