/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.models;

import java.time.LocalDate;
import java.util.Arrays;
import net.finmath.fouriermethod.CharacteristicFunction;
import net.finmath.fouriermethod.models.CharacteristicFunctionModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import org.apache.commons.math3.complex.Complex;

public class BatesModel
implements CharacteristicFunctionModel {
    private final LocalDate referenceDate;
    private final double initialValue;
    private final DiscountCurve discountCurveForForwardRate;
    private final double riskFreeRate;
    private final DiscountCurve discountCurveForDiscountRate;
    private final double discountRate;
    private final double[] volatility;
    private final double[] alpha;
    private final double[] beta;
    private final double[] sigma;
    private final double[] rho;
    private final double[] lambda;
    private final double k;
    private final double delta;
    private final int numberOfFactors;

    public BatesModel(LocalDate referenceDate, double initialValue, DiscountCurve discountCurveForForwardRate, DiscountCurve discountCurveForDiscountRate, double[] volatility, double[] alpha, double[] beta, double[] sigma, double[] rho, double[] lambda, double k, double delta) {
        this.referenceDate = referenceDate;
        this.initialValue = initialValue;
        this.discountCurveForForwardRate = discountCurveForForwardRate;
        this.riskFreeRate = Double.NaN;
        this.discountCurveForDiscountRate = discountCurveForDiscountRate;
        this.discountRate = Double.NaN;
        this.volatility = volatility;
        this.alpha = alpha;
        this.beta = beta;
        this.sigma = sigma;
        this.rho = rho;
        this.lambda = lambda;
        this.k = k;
        this.delta = delta;
        this.numberOfFactors = alpha.length;
    }

    public BatesModel(double initialValue, DiscountCurve discountCurveForForwardRate, DiscountCurve discountCurveForDiscountRate, double[] volatility, double[] alpha, double[] beta, double[] sigma, double[] rho, double[] lambda, double k, double delta) {
        this(null, initialValue, discountCurveForForwardRate, discountCurveForDiscountRate, volatility, alpha, beta, sigma, rho, lambda, k, delta);
    }

    public BatesModel(double initialValue, double riskFreeRate, double discountRate, double[] volatility, double[] alpha, double[] beta, double[] sigma, double[] rho, double[] lambda, double k, double delta) {
        this.referenceDate = null;
        this.initialValue = initialValue;
        this.discountCurveForForwardRate = null;
        this.riskFreeRate = riskFreeRate;
        this.discountCurveForDiscountRate = null;
        this.discountRate = discountRate;
        this.volatility = volatility;
        this.alpha = alpha;
        this.beta = beta;
        this.sigma = sigma;
        this.rho = rho;
        this.lambda = lambda;
        this.k = k;
        this.delta = delta;
        this.numberOfFactors = alpha.length;
    }

    public BatesModel(double initialValue, double riskFreeRate, double volatility, double alpha, double beta, double sigma, double rho, double lambdaZero, double lambdaOne, double k, double delta) {
        this(initialValue, riskFreeRate, riskFreeRate, new double[]{volatility}, new double[]{alpha}, new double[]{beta}, new double[]{sigma}, new double[]{rho}, new double[]{lambdaZero, lambdaOne}, k, delta);
    }

    @Override
    public CharacteristicFunction apply(final double time) {
        final double logDiscountFactorForForward = this.getLogDiscountFactorForForward(time);
        final double logDiscountFactorForDiscounting = this.getLogDiscountFactorForDiscounting(time);
        return new CharacteristicFunction(){

            @Override
            public Complex apply(Complex argument) {
                Complex iargument = argument.multiply(Complex.I);
                Complex c = iargument.multiply(iargument).add(iargument.multiply(-1)).multiply(0.5 * BatesModel.this.delta * BatesModel.this.delta).exp().multiply(new Complex(1.0 + BatesModel.this.k).pow(iargument)).add(-1.0).add(iargument.multiply(-BatesModel.this.k));
                Complex[] gamma = new Complex[BatesModel.this.numberOfFactors];
                Complex[] a = new Complex[BatesModel.this.numberOfFactors];
                Complex[] b = new Complex[BatesModel.this.numberOfFactors];
                for (int i = 0; i < BatesModel.this.numberOfFactors; ++i) {
                    gamma[i] = iargument.multiply(BatesModel.this.rho[i] * BatesModel.this.sigma[i]).subtract(BatesModel.this.beta[i]).pow(2.0).subtract(iargument.multiply(iargument).add(iargument.multiply(-1)).multiply(0.5).add(c.multiply(BatesModel.this.lambda[i + 1])).multiply(2.0 * BatesModel.this.sigma[i] * BatesModel.this.sigma[i])).sqrt();
                    a[i] = iargument.multiply(BatesModel.this.rho[i] * BatesModel.this.sigma[i]).subtract(BatesModel.this.beta[i]).subtract(gamma[i]).multiply(-BatesModel.this.alpha[i] * time / (BatesModel.this.sigma[i] * BatesModel.this.sigma[i])).subtract(iargument.multiply(BatesModel.this.rho[i] * BatesModel.this.sigma[i]).subtract(BatesModel.this.beta[i]).subtract(gamma[i]).multiply(new Complex(1.0).divide(gamma[i].multiply(time).exp()).subtract(1.0).divide(gamma[i])).multiply(0.5).add(new Complex(1.0).divide(gamma[i].multiply(time).exp())).log().add(gamma[i].multiply(time)).multiply(2.0 * BatesModel.this.alpha[i] / (BatesModel.this.sigma[i] * BatesModel.this.sigma[i])));
                    b[i] = iargument.multiply(iargument).add(iargument.multiply(-1)).multiply(0.5).add(c.multiply(BatesModel.this.lambda[i + 1])).multiply(-2).divide(iargument.multiply(BatesModel.this.rho[i] * BatesModel.this.sigma[i]).subtract(BatesModel.this.beta[i]).add(gamma[i].multiply(new Complex(1.0).divide(gamma[i].multiply(time).exp()).add(1.0).divide(new Complex(1.0).divide(gamma[i].multiply(time).exp()).subtract(1.0)))));
                }
                Complex characteristicFunction = a[0].add(b[0].multiply(BatesModel.this.volatility[0])).add(c.multiply(time * BatesModel.this.lambda[0])).add(iargument.multiply(Math.log(BatesModel.this.initialValue) - logDiscountFactorForForward)).add(logDiscountFactorForDiscounting);
                if (BatesModel.this.numberOfFactors == 2) {
                    characteristicFunction = characteristicFunction.add(a[1]).add(b[1].multiply(BatesModel.this.volatility[1]));
                }
                characteristicFunction = characteristicFunction.exp();
                return characteristicFunction;
            }
        };
    }

    private double getLogDiscountFactorForForward(double time) {
        return this.discountCurveForForwardRate == null ? -this.riskFreeRate * time : Math.log(this.discountCurveForForwardRate.getDiscountFactor(null, time));
    }

    private double getLogDiscountFactorForDiscounting(double time) {
        return this.discountCurveForDiscountRate == null ? -this.discountRate * time : Math.log(this.discountCurveForDiscountRate.getDiscountFactor(null, time));
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public double getInitialValue() {
        return this.initialValue;
    }

    public double getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public double[] getVolatility() {
        return this.volatility;
    }

    public double getDiscountRate() {
        return this.discountRate;
    }

    public double[] getAlpha() {
        return this.alpha;
    }

    public double[] getBeta() {
        return this.beta;
    }

    public double[] getSigma() {
        return this.sigma;
    }

    public double[] getRho() {
        return this.rho;
    }

    public double[] getLambda() {
        return this.lambda;
    }

    public double getK() {
        return this.k;
    }

    public double getDelta() {
        return this.delta;
    }

    public int getNumberOfFactors() {
        return this.numberOfFactors;
    }

    public String toString() {
        return "BatesModel [initialValue=" + this.initialValue + ", riskFreeRate=" + this.riskFreeRate + ", volatility=" + Arrays.toString(this.volatility) + ", discountRate=" + this.discountRate + ", alpha=" + Arrays.toString(this.alpha) + ", beta=" + Arrays.toString(this.beta) + ", sigma=" + Arrays.toString(this.sigma) + ", rho=" + Arrays.toString(this.rho) + ", lambda=" + Arrays.toString(this.lambda) + ", k=" + this.k + ", delta=" + this.delta + ", numberOfFactors=" + this.numberOfFactors + "]";
    }
}

