/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.fouriermethod.models;

import java.time.LocalDate;
import net.finmath.fouriermethod.CharacteristicFunction;
import net.finmath.fouriermethod.models.CharacteristicFunctionModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import org.apache.commons.math3.complex.Complex;

public class MertonModel
implements CharacteristicFunctionModel {
    private final LocalDate referenceDate;
    private final double initialValue;
    private final DiscountCurve discountCurveForForwardRate;
    private final double riskFreeRate;
    private final DiscountCurve discountCurveForDiscountRate;
    private final double discountRate;
    private final double volatility;
    private final double jumpIntensity;
    private final double jumpSizeMean;
    private final double jumpSizeStdDev;

    public MertonModel(LocalDate referenceDate, double initialValue, DiscountCurve discountCurveForForwardRate, DiscountCurve discountCurveForDiscountRate, double volatility, double jumpIntensity, double jumpSizeMean, double jumpSizeStdDev) {
        this.referenceDate = referenceDate;
        this.initialValue = initialValue;
        this.discountCurveForForwardRate = discountCurveForForwardRate;
        this.riskFreeRate = Double.NaN;
        this.discountCurveForDiscountRate = discountCurveForDiscountRate;
        this.discountRate = Double.NaN;
        this.volatility = volatility;
        this.jumpIntensity = jumpIntensity;
        this.jumpSizeMean = jumpSizeMean;
        this.jumpSizeStdDev = jumpSizeStdDev;
    }

    public MertonModel(double initialValue, double riskFreeRate, double discountRate, double volatility, double jumpIntensity, double jumpSizeMean, double jumpSizeStdDev) {
        this.referenceDate = null;
        this.initialValue = initialValue;
        this.discountCurveForForwardRate = null;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.discountCurveForDiscountRate = null;
        this.discountRate = discountRate;
        this.jumpIntensity = jumpIntensity;
        this.jumpSizeMean = jumpSizeMean;
        this.jumpSizeStdDev = jumpSizeStdDev;
    }

    public MertonModel(double initialValue, double riskFreeRate, double volatility, double jumpIntensity, double jumpSizeMean, double jumpSizeStdDev) {
        this(initialValue, riskFreeRate, riskFreeRate, volatility, jumpIntensity, jumpSizeMean, jumpSizeStdDev);
    }

    @Override
    public CharacteristicFunction apply(final double time) {
        final double logDiscountFactorForForward = this.getLogDiscountFactorForForward(time);
        final double logDiscountFactorForDiscounting = this.getLogDiscountFactorForDiscounting(time);
        final double transformedMean = this.jumpSizeMean - 0.5 * this.jumpSizeStdDev * this.jumpSizeStdDev;
        return new CharacteristicFunction(){

            @Override
            public Complex apply(Complex argument) {
                Complex iargument = argument.multiply(Complex.I);
                Complex exponent = iargument.multiply(transformedMean).add(iargument.multiply(iargument.multiply(MertonModel.this.jumpSizeStdDev * MertonModel.this.jumpSizeStdDev / 2.0)));
                Complex jumpTransform = exponent.exp().subtract(1.0).multiply(MertonModel.this.jumpIntensity * time);
                double jumpTransformCompensator = MertonModel.this.jumpIntensity * time * (Math.exp(transformedMean + MertonModel.this.jumpSizeStdDev * MertonModel.this.jumpSizeStdDev / 2.0) - 1.0);
                return iargument.multiply(iargument.multiply(0.5 * MertonModel.this.volatility * MertonModel.this.volatility * time).add(Math.log(MertonModel.this.initialValue) - 0.5 * MertonModel.this.volatility * MertonModel.this.volatility * time - logDiscountFactorForForward)).add(logDiscountFactorForDiscounting).add(jumpTransform.subtract(jumpTransformCompensator)).exp();
            }
        };
    }

    private double getLogDiscountFactorForForward(double time) {
        return this.discountCurveForForwardRate == null ? -this.riskFreeRate * time : Math.log(this.discountCurveForForwardRate.getDiscountFactor(null, time));
    }

    private double getLogDiscountFactorForDiscounting(double time) {
        return this.discountCurveForDiscountRate == null ? -this.discountRate * time : Math.log(this.discountCurveForDiscountRate.getDiscountFactor(null, time));
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public double getInitialValue() {
        return this.initialValue;
    }

    public DiscountCurve getDiscountCurveForForwardRate() {
        return this.discountCurveForForwardRate;
    }

    public double getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public DiscountCurve getDiscountCurveForDiscountRate() {
        return this.discountCurveForDiscountRate;
    }

    public double getDiscountRate() {
        return this.discountRate;
    }

    public double getVolatility() {
        return this.volatility;
    }

    public double getJumpIntensity() {
        return this.jumpIntensity;
    }

    public double getJumpSizeMean() {
        return this.jumpSizeMean;
    }

    public double getJumpSizeStdDev() {
        return this.jumpSizeStdDev;
    }

    public String toString() {
        return "MertonModel [initialValue=" + this.initialValue + ", discountCurveForForwardRate=" + this.discountCurveForForwardRate + ", riskFreeRate=" + this.riskFreeRate + ", discountCurveForDiscountRate=" + this.discountCurveForDiscountRate + ", discountRate=" + this.discountRate + ", volatility=" + this.volatility + ", jumpIntensity=" + this.jumpIntensity + ", jumpSizeMean=" + this.jumpSizeMean + ", jumpSizeStdDev=" + this.jumpSizeStdDev + "]";
    }
}

