/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.functions;

import org.apache.commons.lang3.Validate;
import org.apache.commons.math3.special.Gamma;

public class NonCentralChiSquaredDistribution {
    private final double nonCentralityHalf;
    private final double degreesOfFreedomHalf;
    private final int summationSplitIndex;
    private final int maxSummation;
    private final double pInitial;
    private static final double PRECISION = 1.0E-16;

    public NonCentralChiSquaredDistribution(double degreesOfFreedom, double nonCentrality) {
        Validate.isTrue((degreesOfFreedom > 0.0 ? 1 : 0) != 0, (String)"Parameter degreesOfFreedom must be > 0 (given %d).", (double)degreesOfFreedom);
        Validate.isTrue((nonCentrality >= 0.0 ? 1 : 0) != 0, (String)"Parameter nonCentrality must be >= 0 (given %d).", (double)nonCentrality);
        this.degreesOfFreedomHalf = degreesOfFreedom / 2.0;
        this.nonCentralityHalf = nonCentrality / 2.0;
        this.summationSplitIndex = (int)Math.round(this.nonCentralityHalf);
        this.maxSummation = Math.max(this.summationSplitIndex, 10000);
        this.pInitial = this.nonCentralityHalf == 0.0 ? 0.0 : Math.exp(-this.nonCentralityHalf + (double)this.summationSplitIndex * Math.log(this.nonCentralityHalf) - Gamma.logGamma((double)(this.summationSplitIndex + 1)));
    }

    public double cumulativeDistribution(double x) {
        double value;
        int i;
        if (x < 0.0) {
            return 0.0;
        }
        double xHalf = x / 2.0;
        double xHalfLog = Math.log(xHalf);
        double gammaRegularizedInitial = Gamma.regularizedGammaP((double)(this.degreesOfFreedomHalf + (double)this.summationSplitIndex), (double)xHalf);
        double p = this.pInitial;
        double gammaRegularized = gammaRegularizedInitial;
        double sum = p * gammaRegularized;
        double error = 0.0;
        double newSum = 0.0;
        for (i = this.summationSplitIndex - 1; i >= 0; --i) {
            value = (p *= (double)(i + 1) / this.nonCentralityHalf) * (gammaRegularized += Math.exp((this.degreesOfFreedomHalf + (double)i) * xHalfLog - xHalf - Gamma.logGamma((double)(this.degreesOfFreedomHalf + (double)i + 1.0)))) - error;
            newSum = sum + value;
            error = newSum - sum - value;
            if (Math.abs(newSum - sum) / newSum <= 1.0E-16) break;
            sum = newSum;
        }
        p = this.pInitial;
        gammaRegularized = gammaRegularizedInitial;
        sum = newSum;
        for (i = this.summationSplitIndex; i < this.summationSplitIndex + this.maxSummation; ++i) {
            value = (p *= this.nonCentralityHalf / (double)(i + 1)) * (gammaRegularized -= Math.exp((this.degreesOfFreedomHalf + (double)i) * xHalfLog - xHalf - Gamma.logGamma((double)(this.degreesOfFreedomHalf + (double)i + 1.0)))) - error;
            newSum = sum + value;
            error = newSum - sum - value;
            if (Math.abs(newSum - sum) / newSum <= 1.0E-16) break;
            sum = newSum;
        }
        return newSum;
    }

    public double getDegreesOfFreedom() {
        return this.degreesOfFreedomHalf * 2.0;
    }

    public double getNonCentrality() {
        return this.nonCentralityHalf * 2.0;
    }
}

