/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.integration;

import java.util.function.DoubleUnaryOperator;
import net.finmath.integration.AbstractRealIntegral;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.integration.RombergIntegrator;

public class RombergRealIntegration
extends AbstractRealIntegral {
    private final int numberOfEvaluationPoints;

    public RombergRealIntegration(double lowerBound, double upperBound, int numberOfEvaluationPoints) {
        super(lowerBound, upperBound);
        this.numberOfEvaluationPoints = numberOfEvaluationPoints;
    }

    @Override
    public double integrate(final DoubleUnaryOperator integrand) {
        return new RombergIntegrator().integrate(this.numberOfEvaluationPoints, new UnivariateFunction(){

            public double value(double argument) {
                return integrand.applyAsDouble(argument);
            }
        }, this.getLowerBound(), this.getUpperBound());
    }
}

