/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.integration;

import java.util.function.DoubleUnaryOperator;
import java.util.stream.IntStream;
import net.finmath.integration.AbstractRealIntegral;
import org.apache.commons.lang3.Validate;

public class SimpsonRealIntegrator
extends AbstractRealIntegral {
    private final int numberOfEvaluationPoints;
    private final boolean useParallelEvaluation;

    public SimpsonRealIntegrator(double lowerBound, double upperBound, int numberOfEvaluationPoints, boolean useParallelEvaluation) {
        super(lowerBound, upperBound);
        Validate.exclusiveBetween((long)2L, (long)Integer.MAX_VALUE, (long)numberOfEvaluationPoints, (String)"Parameter numberOfEvaluationPoints required to be > 2.");
        this.numberOfEvaluationPoints = numberOfEvaluationPoints;
        this.useParallelEvaluation = useParallelEvaluation;
    }

    public SimpsonRealIntegrator(double lowerBound, double upperBound, int numberOfEvaluationPoints) {
        this(lowerBound, upperBound, numberOfEvaluationPoints, false);
    }

    @Override
    public double integrate(DoubleUnaryOperator integrand) {
        double lowerBound = this.getLowerBound();
        double upperBound = this.getUpperBound();
        double range = upperBound - lowerBound;
        int numberOfDoubleSizeIntervalls = (int)((double)(this.numberOfEvaluationPoints - 1) / 2.0);
        double doubleIntervall = range / (double)numberOfDoubleSizeIntervalls;
        double singleIntervall = 0.5 * doubleIntervall;
        IntStream intervals = IntStream.range(1, numberOfDoubleSizeIntervalls);
        if (this.useParallelEvaluation) {
            intervals = intervals.parallel();
        }
        double sum = intervals.mapToDouble(i -> integrand.applyAsDouble(lowerBound + (double)i * doubleIntervall) + 2.0 * integrand.applyAsDouble(lowerBound + (double)i * doubleIntervall + singleIntervall)).sum();
        return (integrand.applyAsDouble(lowerBound) + 2.0 * (sum += 2.0 * integrand.applyAsDouble(lowerBound + singleIntervall)) + integrand.applyAsDouble(upperBound)) / 3.0 * singleIntervall;
    }
}

