/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.interpolation;

import java.util.Arrays;
import java.util.function.BiFunction;

public class BiLinearInterpolation
implements BiFunction<Double, Double, Double> {
    private final double[] x;
    private final double[] y;
    private final double[][] z;

    public BiLinearInterpolation(double[] x, double[] y, double[][] z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public Double apply(Double x, Double y) {
        return this.getValue(x, y);
    }

    double getValue(double x, double y) {
        int indexGreaterOrEqualX = Arrays.binarySearch(this.x, x);
        if (indexGreaterOrEqualX < 0) {
            indexGreaterOrEqualX = -indexGreaterOrEqualX - 1;
        }
        int upperIndexX = Math.min(Math.max(indexGreaterOrEqualX, 0), this.x.length - 1);
        int lowerIndexX = Math.min(Math.max(upperIndexX - 1, 0), this.x.length - 1);
        int indexGreaterOrEqualY = Arrays.binarySearch(this.y, y);
        if (indexGreaterOrEqualY < 0) {
            indexGreaterOrEqualY = -indexGreaterOrEqualY - 1;
        }
        int upperIndexY = Math.min(Math.max(indexGreaterOrEqualY, 0), this.y.length - 1);
        int lowerIndexY = Math.min(Math.max(upperIndexY - 1, 0), this.y.length - 1);
        if (upperIndexX == lowerIndexX) {
            ++upperIndexX;
        }
        if (upperIndexY == lowerIndexY) {
            ++upperIndexY;
        }
        double alphaX = (this.x[upperIndexX] - x) / (this.x[upperIndexX] - this.x[lowerIndexX]);
        double alphaY = (this.y[upperIndexY] - y) / (this.y[upperIndexY] - this.y[lowerIndexY]);
        double interpolatedValue = alphaX * alphaY * this.z[lowerIndexX][lowerIndexY] + alphaX * (1.0 - alphaY) * this.z[lowerIndexX][upperIndexY] + (1.0 - alphaX) * alphaY * this.z[upperIndexX][lowerIndexY] + (1.0 - alphaX) * (1.0 - alphaY) * this.z[upperIndexX][upperIndexY];
        return interpolatedValue;
    }
}

