/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.calibration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.finmath.marketdata.calibration.ParameterObject;
import net.finmath.marketdata.calibration.Solver;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.AnalyticModelFromCurvesAndVols;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterpolation;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveFromDiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurveInterpolation;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProduct;
import net.finmath.marketdata.products.Deposit;
import net.finmath.marketdata.products.ForwardRateAgreement;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapLeg;
import net.finmath.optimizer.SolverException;
import net.finmath.time.RegularSchedule;
import net.finmath.time.Schedule;
import net.finmath.time.TimeDiscretizationFromArray;

public class CalibratedCurves {
    private static final boolean isUseForwardCurve = Boolean.parseBoolean(System.getProperty("net.finmath.marketdata.calibration.CalibratedCurves.isUseForwardCurve", "true"));
    private static final boolean isCreateDefaultCurvesForMissingCurves = Boolean.parseBoolean(System.getProperty("net.finmath.marketdata.calibration.CalibratedCurves.isCreateDefaultCurvesForMissingCurves", "false"));
    private AnalyticModel model = new AnalyticModelFromCurvesAndVols();
    private final Set<ParameterObject> objectsToCalibrate = new LinkedHashSet<ParameterObject>();
    private final Vector<AnalyticProduct> calibrationProducts = new Vector();
    private final Vector<String> calibrationProductsSymbols = new Vector();
    private final List<CalibrationSpec> calibrationSpecs = new ArrayList<CalibrationSpec>();
    private final double evaluationTime;
    private final double calibrationAccuracy;
    private final int lastNumberOfInterations;
    private double lastAccuracy;

    public CalibratedCurves(List<CalibrationSpec> calibrationSpecs, AnalyticModel calibrationModel, double evaluationTime, double calibrationAccuracy) throws SolverException, CloneNotSupportedException {
        if (calibrationModel != null) {
            this.model = calibrationModel.getCloneForParameter(null);
        }
        this.evaluationTime = evaluationTime;
        this.calibrationAccuracy = calibrationAccuracy;
        for (CalibrationSpec calibrationSpec : calibrationSpecs) {
            this.add(calibrationSpec);
        }
        this.lastNumberOfInterations = this.calibrate(calibrationAccuracy);
    }

    public CalibratedCurves(CalibrationSpec[] calibrationSpecs, AnalyticModelFromCurvesAndVols calibrationModel, double evaluationTime, double calibrationAccuracy) throws SolverException, CloneNotSupportedException {
        if (calibrationModel != null) {
            this.model = calibrationModel.getCloneForParameter(null);
        }
        this.evaluationTime = evaluationTime;
        this.calibrationAccuracy = calibrationAccuracy;
        for (CalibrationSpec calibrationSpec : calibrationSpecs) {
            this.add(calibrationSpec);
        }
        this.lastNumberOfInterations = this.calibrate(calibrationAccuracy);
    }

    public CalibratedCurves(CalibrationSpec[] calibrationSpecs, AnalyticModelFromCurvesAndVols calibrationModel, double calibrationAccuracy) throws SolverException, CloneNotSupportedException {
        this(calibrationSpecs, calibrationModel, 0.0, calibrationAccuracy);
    }

    public CalibratedCurves(CalibrationSpec[] calibrationSpecs, AnalyticModelFromCurvesAndVols calibrationModel) throws SolverException, CloneNotSupportedException {
        this(calibrationSpecs, calibrationModel, 0.0);
    }

    public CalibratedCurves(Collection<CalibrationSpec> calibrationSpecs) throws SolverException, CloneNotSupportedException {
        this(calibrationSpecs.toArray(new CalibrationSpec[calibrationSpecs.size()]), null);
    }

    public CalibratedCurves(CalibrationSpec[] calibrationSpecs) throws SolverException, CloneNotSupportedException {
        this(calibrationSpecs, null, 0.0);
    }

    public AnalyticProduct getCalibrationProductForSpec(CalibrationSpec calibrationSpec) {
        String forwardCurveReceiverName = calibrationSpec.forwardCurveReceiverName;
        String forwardCurvePayerName = calibrationSpec.forwardCurvePayerName;
        if (isCreateDefaultCurvesForMissingCurves) {
            this.createDiscountCurve(calibrationSpec.discountCurveReceiverName);
            this.createDiscountCurve(calibrationSpec.discountCurvePayerName);
            forwardCurveReceiverName = this.createForwardCurve(calibrationSpec.swapTenorDefinitionReceiver, calibrationSpec.forwardCurveReceiverName);
            forwardCurvePayerName = this.createForwardCurve(calibrationSpec.swapTenorDefinitionPayer, calibrationSpec.forwardCurvePayerName);
        } else {
            Predicate<String> discountCurveMissing = new Predicate<String>(){

                @Override
                public boolean test(String curveName) {
                    return curveName != null && curveName.length() > 0 && CalibratedCurves.this.model.getDiscountCurve(curveName) == null;
                }
            };
            Predicate<String> forwardCurveMissing = new Predicate<String>(){

                @Override
                public boolean test(String curveName) {
                    return curveName != null && curveName.length() > 0 && CalibratedCurves.this.model.getForwardCurve(curveName) == null;
                }
            };
            if (discountCurveMissing.test(calibrationSpec.discountCurveReceiverName)) {
                throw new IllegalArgumentException("Discount curve " + calibrationSpec.discountCurveReceiverName + " missing. Needs to be part of model " + this.model + ".");
            }
            if (discountCurveMissing.test(calibrationSpec.discountCurvePayerName)) {
                throw new IllegalArgumentException("Discount curve " + calibrationSpec.discountCurvePayerName + " missing. Needs to be part of model " + this.model + ".");
            }
            if (forwardCurveMissing.test(calibrationSpec.forwardCurveReceiverName)) {
                throw new IllegalArgumentException("Forward curve " + calibrationSpec.forwardCurveReceiverName + " missing. Needs to be part of model " + this.model + ".");
            }
            if (forwardCurveMissing.test(calibrationSpec.forwardCurvePayerName)) {
                throw new IllegalArgumentException("Forward curve " + calibrationSpec.forwardCurvePayerName + " missing. Needs to be part of model " + this.model + ".");
            }
        }
        Schedule tenorReceiver = calibrationSpec.swapTenorDefinitionReceiver;
        Schedule tenorPayer = calibrationSpec.swapTenorDefinitionPayer;
        AbstractAnalyticProduct product = null;
        if (calibrationSpec.type.toLowerCase().equals("deposit")) {
            product = new Deposit(tenorReceiver, calibrationSpec.spreadReceiver, calibrationSpec.discountCurveReceiverName);
        } else if (calibrationSpec.type.toLowerCase().equals("fra")) {
            product = new ForwardRateAgreement(tenorReceiver, calibrationSpec.spreadReceiver, forwardCurveReceiverName, calibrationSpec.discountCurveReceiverName);
        } else if (calibrationSpec.type.toLowerCase().equals("future")) {
            product = new ForwardRateAgreement(calibrationSpec.swapTenorDefinitionReceiver, 1.0 - calibrationSpec.spreadReceiver / 100.0, forwardCurveReceiverName, calibrationSpec.discountCurveReceiverName);
        } else if (calibrationSpec.type.toLowerCase().equals("swapleg")) {
            product = new SwapLeg(tenorReceiver, forwardCurveReceiverName, calibrationSpec.spreadReceiver, calibrationSpec.discountCurveReceiverName, true);
        } else if (calibrationSpec.type.toLowerCase().equals("swap")) {
            SwapLeg legReceiver = new SwapLeg(tenorReceiver, forwardCurveReceiverName, calibrationSpec.spreadReceiver, calibrationSpec.discountCurveReceiverName, true);
            SwapLeg legPayer = new SwapLeg(tenorPayer, forwardCurvePayerName, calibrationSpec.spreadPayer, calibrationSpec.discountCurvePayerName, true);
            product = new Swap(legReceiver, legPayer);
        } else if (calibrationSpec.type.toLowerCase().equals("swapwithresetonreceiver")) {
            String discountCurveForNotionalResetName = calibrationSpec.discountCurvePayerName;
            SwapLeg legReceiver = new SwapLeg(tenorReceiver, forwardCurveReceiverName, calibrationSpec.spreadReceiver, calibrationSpec.discountCurveReceiverName, discountCurveForNotionalResetName, true);
            SwapLeg legPayer = new SwapLeg(tenorPayer, forwardCurvePayerName, calibrationSpec.spreadPayer, calibrationSpec.discountCurvePayerName, true);
            product = new Swap(legReceiver, legPayer);
        } else if (calibrationSpec.type.toLowerCase().equals("swapwithresetonpayer")) {
            String discountCurveForNotionalResetName = calibrationSpec.discountCurveReceiverName;
            SwapLeg legReceiver = new SwapLeg(tenorReceiver, forwardCurveReceiverName, calibrationSpec.spreadReceiver, calibrationSpec.discountCurveReceiverName, true);
            SwapLeg legPayer = new SwapLeg(tenorPayer, forwardCurvePayerName, calibrationSpec.spreadPayer, calibrationSpec.discountCurvePayerName, discountCurveForNotionalResetName, true);
            product = new Swap(legReceiver, legPayer);
        } else {
            throw new RuntimeException("Product of type " + calibrationSpec.type + " unknown.");
        }
        return product;
    }

    public AnalyticModel getModel() {
        return this.model;
    }

    public Curve getCurve(String name) {
        return this.model.getCurve(name);
    }

    public int getLastNumberOfInterations() {
        return this.lastNumberOfInterations;
    }

    public CalibratedCurves getCloneShifted(String symbol, double shift) throws SolverException, CloneNotSupportedException {
        ArrayList<CalibrationSpec> calibrationSpecsShifted = new ArrayList<CalibrationSpec>();
        for (CalibrationSpec calibrationSpec : this.calibrationSpecs) {
            if (calibrationSpec.symbol.equals(symbol)) {
                calibrationSpecsShifted.add(calibrationSpec.getCloneShifted(shift));
                continue;
            }
            calibrationSpecsShifted.add(calibrationSpec);
        }
        return new CalibratedCurves(calibrationSpecsShifted, this.model, this.evaluationTime, this.calibrationAccuracy);
    }

    public CalibratedCurves getCloneShifted(Map<String, Double> shifts) throws SolverException, CloneNotSupportedException {
        ArrayList<CalibrationSpec> calibrationSpecsShifted = new ArrayList<CalibrationSpec>();
        for (CalibrationSpec calibrationSpec : this.calibrationSpecs) {
            if (shifts.containsKey(calibrationSpec)) {
                calibrationSpecsShifted.add(calibrationSpec.getCloneShifted(shifts.get(calibrationSpec)));
                continue;
            }
            calibrationSpecsShifted.add(calibrationSpec);
        }
        return new CalibratedCurves(calibrationSpecsShifted, this.model, this.evaluationTime, this.calibrationAccuracy);
    }

    public CalibratedCurves getCloneShifted(Pattern symbolRegExp, double shift) throws SolverException, CloneNotSupportedException {
        ArrayList<CalibrationSpec> calibrationSpecsShifted = new ArrayList<CalibrationSpec>();
        for (CalibrationSpec calibrationSpec : this.calibrationSpecs) {
            Matcher matcher = symbolRegExp.matcher(calibrationSpec.symbol);
            if (matcher.matches()) {
                calibrationSpecsShifted.add(calibrationSpec.getCloneShifted(shift));
                continue;
            }
            calibrationSpecsShifted.add(calibrationSpec);
        }
        return new CalibratedCurves(calibrationSpecsShifted, this.model, this.evaluationTime, this.calibrationAccuracy);
    }

    public CalibratedCurves getCloneShiftedForRegExp(String symbolRegExp, double shift) throws SolverException, CloneNotSupportedException {
        return this.getCloneShifted(Pattern.compile(symbolRegExp), shift);
    }

    public double getLastAccuracy() {
        return this.lastAccuracy;
    }

    public AnalyticProduct getCalibrationProductForSymbol(String symbol) {
        for (int i = 0; i < this.calibrationProductsSymbols.size(); ++i) {
            String calibrationProductSymbol = this.calibrationProductsSymbols.get(i);
            if (!calibrationProductSymbol.equals(symbol)) continue;
            return this.calibrationProducts.get(i);
        }
        return null;
    }

    private int calibrate(double accuracy) throws SolverException {
        Solver solver = new Solver(this.model, this.calibrationProducts, this.evaluationTime, accuracy);
        this.model = solver.getCalibratedModel(this.objectsToCalibrate);
        this.lastAccuracy = solver.getAccuracy();
        return solver.getIterations();
    }

    private String add(CalibrationSpec calibrationSpec) throws CloneNotSupportedException {
        this.calibrationSpecs.add(calibrationSpec);
        this.calibrationProducts.add(this.getCalibrationProductForSpec(calibrationSpec));
        this.calibrationProductsSymbols.add(calibrationSpec.symbol);
        Curve calibrationCurveOld = this.model.getCurve(calibrationSpec.calibrationCurveName);
        if (calibrationCurveOld == null) {
            throw new IllegalArgumentException("Calibration curve " + calibrationSpec.calibrationCurveName + " does not exist. This should not happen. Possible reason: The given calibration product does not depend on the given calibration curve.");
        }
        this.objectsToCalibrate.remove(calibrationCurveOld);
        double valueGuess = DiscountCurve.class.isInstance(calibrationCurveOld) ? 1.0 : (ForwardCurve.class.isInstance(calibrationCurveOld) ? 0.0 : 1.0);
        Curve calibrationCurve = calibrationCurveOld.getCloneBuilder().addPoint(calibrationSpec.calibrationTime, valueGuess, true).build();
        this.model = this.model.addCurves(calibrationCurve);
        this.objectsToCalibrate.add(calibrationCurve);
        return calibrationSpec.type;
    }

    private DiscountCurve createDiscountCurve(String discountCurveName) {
        DiscountCurve discountCurve = this.model.getDiscountCurve(discountCurveName);
        if (discountCurve == null) {
            discountCurve = DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(discountCurveName, new double[]{0.0}, new double[]{1.0});
            this.model = this.model.addCurves(discountCurve);
        }
        return discountCurve;
    }

    private String createForwardCurve(Schedule swapTenorDefinition, String forwardCurveName) {
        String indexMaturityCode = null;
        if (forwardCurveName.contains("_12M") || forwardCurveName.contains("-12M") || forwardCurveName.contains(" 12M")) {
            indexMaturityCode = "12M";
        }
        if (forwardCurveName.contains("_1M") || forwardCurveName.contains("-1M") || forwardCurveName.contains(" 1M")) {
            indexMaturityCode = "1M";
        }
        if (forwardCurveName.contains("_6M") || forwardCurveName.contains("-6M") || forwardCurveName.contains(" 6M")) {
            indexMaturityCode = "6M";
        }
        if (forwardCurveName.contains("_3M") || forwardCurveName.contains("-3M") || forwardCurveName.contains(" 3M")) {
            indexMaturityCode = "3M";
        }
        if (forwardCurveName == null || forwardCurveName.isEmpty()) {
            return null;
        }
        Curve curve = this.model.getCurve(forwardCurveName);
        Curve forwardCurve = null;
        if (curve == null) {
            if (isUseForwardCurve) {
                curve = new ForwardCurveInterpolation(forwardCurveName, swapTenorDefinition.getReferenceDate(), indexMaturityCode, ForwardCurveInterpolation.InterpolationEntityForward.FORWARD, null);
            } else {
                curve = DiscountCurveInterpolation.createDiscountCurveFromDiscountFactors(forwardCurveName, new double[]{0.0}, new double[]{1.0});
                this.model = this.model.addCurves(curve);
            }
        }
        forwardCurve = DiscountCurve.class.isInstance(curve) ? new ForwardCurveFromDiscountCurve(curve.getName(), swapTenorDefinition.getReferenceDate(), indexMaturityCode) : curve;
        this.model = this.model.addCurves(forwardCurve);
        return forwardCurve.getName();
    }

    public static class CalibrationSpec {
        private String symbol;
        private final String type;
        private final Schedule swapTenorDefinitionReceiver;
        private final String forwardCurveReceiverName;
        private final double spreadReceiver;
        private final String discountCurveReceiverName;
        private Schedule swapTenorDefinitionPayer;
        private String forwardCurvePayerName;
        private double spreadPayer;
        private String discountCurvePayerName;
        private final String calibrationCurveName;
        private final double calibrationTime;

        public CalibrationSpec(String symbol, String type, Schedule swapTenorDefinitionReceiver, String forwardCurveReceiverName, double spreadReceiver, String discountCurveReceiverName, Schedule swapTenorDefinitionPayer, String forwardCurvePayerName, double spreadPayer, String discountCurvePayerName, String calibrationCurveName, double calibrationTime) {
            this.symbol = symbol;
            this.type = type;
            this.swapTenorDefinitionReceiver = swapTenorDefinitionReceiver;
            this.forwardCurveReceiverName = forwardCurveReceiverName;
            this.spreadReceiver = spreadReceiver;
            this.discountCurveReceiverName = discountCurveReceiverName;
            this.swapTenorDefinitionPayer = swapTenorDefinitionPayer;
            this.forwardCurvePayerName = forwardCurvePayerName;
            this.spreadPayer = spreadPayer;
            this.discountCurvePayerName = discountCurvePayerName;
            this.calibrationCurveName = calibrationCurveName;
            this.calibrationTime = calibrationTime;
        }

        public CalibrationSpec(String type, Schedule swapTenorDefinitionReceiver, String forwardCurveReceiverName, double spreadReceiver, String discountCurveReceiverName, Schedule swapTenorDefinitionPayer, String forwardCurvePayerName, double spreadPayer, String discountCurvePayerName, String calibrationCurveName, double calibrationTime) {
            this(null, type, swapTenorDefinitionReceiver, forwardCurveReceiverName, spreadReceiver, discountCurveReceiverName, swapTenorDefinitionPayer, forwardCurvePayerName, spreadPayer, discountCurvePayerName, calibrationCurveName, calibrationTime);
        }

        public CalibrationSpec(String type, double[] swapTenorDefinitionReceiver, String forwardCurveReceiverName, double spreadReceiver, String discountCurveReceiverName, double[] swapTenorDefinitionPayer, String forwardCurvePayerName, double spreadPayer, String discountCurvePayerName, String calibrationCurveName, double calibrationTime) {
            this.type = type;
            this.swapTenorDefinitionReceiver = new RegularSchedule(new TimeDiscretizationFromArray(swapTenorDefinitionReceiver[0], swapTenorDefinitionReceiver[1], swapTenorDefinitionReceiver[2], TimeDiscretizationFromArray.ShortPeriodLocation.SHORT_PERIOD_AT_START));
            this.forwardCurveReceiverName = forwardCurveReceiverName;
            this.spreadReceiver = spreadReceiver;
            this.discountCurveReceiverName = discountCurveReceiverName;
            this.swapTenorDefinitionPayer = new RegularSchedule(new TimeDiscretizationFromArray(swapTenorDefinitionPayer[0], swapTenorDefinitionPayer[1], swapTenorDefinitionPayer[2], TimeDiscretizationFromArray.ShortPeriodLocation.SHORT_PERIOD_AT_START));
            this.forwardCurvePayerName = forwardCurvePayerName;
            this.spreadPayer = spreadPayer;
            this.discountCurvePayerName = discountCurvePayerName;
            this.calibrationCurveName = calibrationCurveName;
            this.calibrationTime = calibrationTime;
        }

        public CalibrationSpec(String type, double[] swapTenorDefinitionReceiver, String forwardCurveReceiverName, double spreadReceiver, String discountCurveReceiverName, String calibrationCurveName, double calibrationTime) {
            this.type = type;
            this.swapTenorDefinitionReceiver = new RegularSchedule(new TimeDiscretizationFromArray(swapTenorDefinitionReceiver[0], swapTenorDefinitionReceiver[1], swapTenorDefinitionReceiver[2], TimeDiscretizationFromArray.ShortPeriodLocation.SHORT_PERIOD_AT_START));
            this.forwardCurveReceiverName = forwardCurveReceiverName;
            this.spreadReceiver = spreadReceiver;
            this.discountCurveReceiverName = discountCurveReceiverName;
            this.calibrationCurveName = calibrationCurveName;
            this.calibrationTime = calibrationTime;
        }

        public CalibrationSpec getCloneShifted(double shift) {
            if (this.discountCurvePayerName == null || this.type.toLowerCase().equals("swapleg") || this.type.toLowerCase().equals("deposit") || this.type.toLowerCase().equals("fra")) {
                return new CalibrationSpec(this.symbol, this.type, this.swapTenorDefinitionReceiver, this.forwardCurveReceiverName, this.spreadReceiver + shift, this.discountCurveReceiverName, this.swapTenorDefinitionPayer, this.forwardCurvePayerName, this.spreadPayer, this.discountCurvePayerName, this.calibrationCurveName, this.calibrationTime);
            }
            return new CalibrationSpec(this.symbol, this.type, this.swapTenorDefinitionReceiver, this.forwardCurveReceiverName, this.spreadReceiver, this.discountCurveReceiverName, this.swapTenorDefinitionPayer, this.forwardCurvePayerName, this.spreadPayer + shift, this.discountCurvePayerName, this.calibrationCurveName, this.calibrationTime);
        }

        public String toString() {
            return "CalibrationSpec [symbol=" + this.symbol + ", type=" + this.type + ", swapTenorDefinitionReceiver=" + this.swapTenorDefinitionReceiver + ", forwardCurveReceiverName=" + this.forwardCurveReceiverName + ", spreadReceiver=" + this.spreadReceiver + ", discountCurveReceiverName=" + this.discountCurveReceiverName + ", swapTenorDefinitionPayer=" + this.swapTenorDefinitionPayer + ", forwardCurvePayerName=" + this.forwardCurvePayerName + ", spreadPayer=" + this.spreadPayer + ", discountCurvePayerName=" + this.discountCurvePayerName + ", calibrationCurveName=" + this.calibrationCurveName + ", calibrationTime=" + this.calibrationTime + "]";
        }

        public String getSymbol() {
            return this.symbol;
        }
    }
}

