/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.cds;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashSet;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.AnalyticModelFromCurvesAndVols;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.DiscountCurveInterpolation;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProduct;
import net.finmath.time.FloatingpointDate;
import net.finmath.time.Period;
import net.finmath.time.Schedule;
import net.finmath.time.ScheduleFromPeriods;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingWeekends;
import net.finmath.time.daycount.DayCountConvention;

public class CDS
extends AbstractAnalyticProduct
implements AnalyticProduct {
    private final Schedule schedule;
    private final String discountCurveName;
    private final String forwardCurveName;
    private final String survivalProbabilityCurveName;
    private final String recoveryRateCurveName;
    private final double fixedFee;
    private final double floatingFeeSpread;
    private final double upfrontPayment;
    private final LocalDate tradeDate;
    private final ValuationModel valuationModel;
    private final DirtyCleanPrice dirtyCleanPrice;
    private final boolean useFinerDiscretization;

    private CDS(Schedule schedule, String discountCurveName, String forwardCurveName, String survivalProbabilityCurveName, String recoveryRateCurveName, double fixedFee, double floatingFeeSpread, double upfrontPayment, LocalDate tradeDate, ValuationModel valuationModel, DirtyCleanPrice dirtyCleanPrice, boolean useFinerDiscretization) {
        this.schedule = schedule;
        this.discountCurveName = discountCurveName;
        this.forwardCurveName = forwardCurveName;
        this.survivalProbabilityCurveName = survivalProbabilityCurveName;
        this.recoveryRateCurveName = recoveryRateCurveName;
        this.fixedFee = fixedFee;
        this.floatingFeeSpread = floatingFeeSpread;
        this.upfrontPayment = upfrontPayment;
        this.tradeDate = tradeDate;
        this.valuationModel = valuationModel;
        this.dirtyCleanPrice = dirtyCleanPrice;
        this.useFinerDiscretization = useFinerDiscretization;
    }

    public CDS(Schedule schedule, String discountCurveName, String survivalProbabilityCurveName, String recoveryRateCurveName, double fixedFee, LocalDate tradeDate, ValuationModel valuationModel, DirtyCleanPrice dirtyCleanPrice, boolean useFinerDiscretization) {
        this(schedule, discountCurveName, null, survivalProbabilityCurveName, recoveryRateCurveName, fixedFee, 0.0, 0.0, tradeDate, valuationModel, dirtyCleanPrice, useFinerDiscretization);
    }

    public CDS(Schedule schedule, String discountCurveName, String survivalProbabilityCurveName, String recoveryRateCurveName, double fixedFee, double upfrontPayment, LocalDate tradeDate, ValuationModel valuationModel, DirtyCleanPrice dirtyCleanPrice, boolean useFinerDiscretization) {
        this(schedule, discountCurveName, null, survivalProbabilityCurveName, recoveryRateCurveName, fixedFee, 0.0, upfrontPayment, tradeDate, valuationModel, dirtyCleanPrice, useFinerDiscretization);
    }

    public CDS(ScheduleFromPeriods schedule, String discountCurveName, String forwardCurveName, String survivalProbabilityCurveName, String recoveryRateCurveName, double floatingFeeSpread, LocalDate tradeDate, ValuationModel valuationModel, DirtyCleanPrice dirtyCleanPrice, boolean useFinerDiscretization) {
        this(schedule, discountCurveName, forwardCurveName, survivalProbabilityCurveName, recoveryRateCurveName, 0.0, floatingFeeSpread, 0.0, tradeDate, valuationModel, dirtyCleanPrice, useFinerDiscretization);
    }

    public CDS(ScheduleFromPeriods schedule, String discountCurveName, String forwardCurveName, String survivalProbabilityCurveName, String recoveryRateCurveName, double floatingFeeSpread, double upfrontPayment, LocalDate tradeDate, ValuationModel valuationModel, DirtyCleanPrice dirtyCleanPrice, boolean useFinerDiscretization) {
        this(schedule, discountCurveName, forwardCurveName, survivalProbabilityCurveName, recoveryRateCurveName, 0.0, floatingFeeSpread, upfrontPayment, tradeDate, valuationModel, dirtyCleanPrice, useFinerDiscretization);
    }

    @Override
    public double getValue(double evaluationTime, AnalyticModel model) {
        int i;
        if (model == null) {
            throw new IllegalArgumentException("model==null");
        }
        ForwardCurve forwardCurveInterpolation = model.getForwardCurve(this.forwardCurveName);
        if (forwardCurveInterpolation == null && this.forwardCurveName != null && this.forwardCurveName.length() > 0) {
            throw new IllegalArgumentException("No forward curve with name '" + this.forwardCurveName + "' was found in the model:\n" + model.toString());
        }
        DiscountCurveInterpolation discountCurve = (DiscountCurveInterpolation)model.getDiscountCurve(this.discountCurveName);
        if (discountCurve == null) {
            throw new IllegalArgumentException("No discount curve with name '" + this.discountCurveName + "' was found in the model:\n" + model.toString());
        }
        Curve survivalProbabilityCurve = model.getCurve(this.survivalProbabilityCurveName);
        if (survivalProbabilityCurve == null) {
            throw new IllegalArgumentException("No survival probability curve with name '" + this.survivalProbabilityCurveName + "' was found in the model:\n" + model.toString());
        }
        Curve recoveryRateCurve = model.getCurve(this.recoveryRateCurveName);
        if (recoveryRateCurve == null) {
            throw new IllegalArgumentException("No recovery rate curve with name '" + this.recoveryRateCurveName + "' was found in the model:\n" + model.toString());
        }
        BusinessdayCalendarExcludingWeekends businessdayCalendarExcludingWeekends = new BusinessdayCalendarExcludingWeekends();
        LocalDate effectiveDate = businessdayCalendarExcludingWeekends.getRolledDate(this.tradeDate, 1);
        HashSet<Double> jointTimeDiscretizationSet = new HashSet<Double>();
        double[] timesDiscountCurve = discountCurve.getTimes();
        for (i = 0; i < timesDiscountCurve.length; ++i) {
            jointTimeDiscretizationSet.add(timesDiscountCurve[i]);
        }
        for (i = 0; i < this.schedule.getNumberOfPeriods(); ++i) {
            jointTimeDiscretizationSet.add(this.schedule.getPeriodStart(i));
            jointTimeDiscretizationSet.add(this.schedule.getPeriodEnd(i));
        }
        Object[] jointTimeDiscretization = jointTimeDiscretizationSet.toArray(new Double[0]);
        Arrays.sort(jointTimeDiscretization);
        boolean upfrontIsNonzero = this.upfrontPayment != 0.0;
        double value = 0.0;
        block7: for (int periodIndex = 0; periodIndex < this.schedule.getNumberOfPeriods(); ++periodIndex) {
            if (upfrontIsNonzero && periodIndex == 0) {
                double upfrontPaymentDate = FloatingpointDate.getFloatingPointDateFromDate(this.schedule.getReferenceDate(), this.tradeDate);
                double discountFactor = discountCurve.getDiscountFactor(model, upfrontPaymentDate);
                double survivalProbabilityFactor = survivalProbabilityCurve.getValue(model, upfrontPaymentDate);
                value += -this.upfrontPayment * discountFactor * survivalProbabilityFactor;
            }
            double paymentDate = this.schedule.getPayment(periodIndex);
            double periodLength = this.schedule.getPeriodLength(periodIndex);
            if (periodIndex == 0 && this.dirtyCleanPrice == DirtyCleanPrice.CLEAN) {
                periodLength = this.schedule.getDaycountconvention().getDaycountFraction(effectiveDate, this.schedule.getPeriod(0).getPeriodEnd());
            }
            if (periodIndex == this.schedule.getNumberOfPeriods() - 1) {
                periodLength += this.schedule.getDaycountconvention().getDaycountFraction(this.schedule.getPeriod(periodIndex).getPeriodEnd(), this.schedule.getPeriod(periodIndex).getPeriodEnd().plusDays(1L));
            }
            double previousPaymentDate = periodIndex > 0 ? this.schedule.getPayment(periodIndex - 1) : 0.0 + this.schedule.getDaycountconvention().getDaycountFraction(this.tradeDate, effectiveDate);
            double discountFactor = paymentDate > evaluationTime ? discountCurve.getDiscountFactor(model, paymentDate) : 0.0;
            double previousDiscountFactor = previousPaymentDate > evaluationTime ? discountCurve.getDiscountFactor(model, previousPaymentDate) : 1.0;
            double survivalProbabilityFactor = paymentDate > evaluationTime ? survivalProbabilityCurve.getValue(model, paymentDate) : 0.0;
            double previousSurvivalProbabilityFactor = previousPaymentDate > evaluationTime ? survivalProbabilityCurve.getValue(model, previousPaymentDate) : 1.0;
            double feePayment = this.fixedFee;
            if (forwardCurveInterpolation != null) {
                feePayment = this.floatingFeeSpread + forwardCurveInterpolation.getForward(model, this.schedule.getFixing(periodIndex));
            }
            double recoveryRate = recoveryRateCurve.getValue(model, paymentDate);
            double periodStartTime = Math.max(this.schedule.getPeriodStart(periodIndex), evaluationTime);
            double periodEndTime = Math.max(this.schedule.getPeriodEnd(periodIndex), evaluationTime);
            double forwardInterestRateFactor = (Math.log(discountCurve.getValue(model, periodStartTime)) - Math.log(discountCurve.getValue(model, periodEndTime))) / (periodEndTime - periodStartTime);
            double hazardRateFactor = (Math.log(survivalProbabilityCurve.getValue(model, periodStartTime)) - Math.log(survivalProbabilityCurve.getValue(model, periodEndTime))) / (periodEndTime - periodStartTime);
            double accruedFactorJPM = hazardRateFactor * (1.0 / Math.pow(forwardInterestRateFactor + hazardRateFactor, 2.0) - ((periodEndTime - periodStartTime) / (forwardInterestRateFactor + hazardRateFactor) + 1.0 / Math.pow(forwardInterestRateFactor + hazardRateFactor, 2.0)) * Math.exp(-(forwardInterestRateFactor + hazardRateFactor) * (periodEndTime - periodStartTime)));
            switch (this.valuationModel) {
                case DISCRETE: {
                    value += -feePayment * periodLength * discountFactor * survivalProbabilityFactor;
                    value += Math.max(1.0 - recoveryRate, 0.0) * discountFactor * (previousSurvivalProbabilityFactor - survivalProbabilityFactor);
                    continue block7;
                }
                case JPM: {
                    double subPeriodEndTime;
                    double subPeriodStartTime;
                    int subTimeIndex;
                    int endIndex;
                    int startIndex;
                    if (this.useFinerDiscretization) {
                        value += -feePayment * periodLength * discountFactor * survivalProbabilityFactor;
                        startIndex = Arrays.binarySearch(jointTimeDiscretization, (Object)periodStartTime);
                        endIndex = Arrays.binarySearch(jointTimeDiscretization, (Object)periodEndTime);
                        for (subTimeIndex = startIndex; subTimeIndex < endIndex; ++subTimeIndex) {
                            subPeriodStartTime = (Double)jointTimeDiscretization[subTimeIndex];
                            subPeriodEndTime = (Double)jointTimeDiscretization[subTimeIndex + 1];
                            double subPeriodLength = subPeriodEndTime - subPeriodStartTime;
                            discountFactor = discountCurve.getDiscountFactor(model, subPeriodEndTime);
                            previousDiscountFactor = discountCurve.getDiscountFactor(model, subPeriodStartTime);
                            survivalProbabilityFactor = survivalProbabilityCurve.getValue(model, subPeriodEndTime);
                            previousSurvivalProbabilityFactor = survivalProbabilityCurve.getValue(model, subPeriodStartTime);
                            forwardInterestRateFactor = (Math.log(discountCurve.getValue(model, subPeriodStartTime)) - Math.log(discountCurve.getValue(model, subPeriodEndTime))) / (subPeriodEndTime - subPeriodStartTime);
                            hazardRateFactor = (Math.log(survivalProbabilityCurve.getValue(model, subPeriodStartTime)) - Math.log(survivalProbabilityCurve.getValue(model, subPeriodEndTime))) / (subPeriodEndTime - subPeriodStartTime);
                            accruedFactorJPM = hazardRateFactor * (1.0 / Math.pow(forwardInterestRateFactor + hazardRateFactor, 2.0) - ((subPeriodEndTime - subPeriodStartTime) / (forwardInterestRateFactor + hazardRateFactor) + 1.0 / Math.pow(forwardInterestRateFactor + hazardRateFactor, 2.0)) * Math.exp(-(forwardInterestRateFactor + hazardRateFactor) * (subPeriodEndTime - subPeriodStartTime)));
                            value += -feePayment * subPeriodLength * previousDiscountFactor * previousSurvivalProbabilityFactor * accruedFactorJPM;
                            value += Math.max(1.0 - recoveryRate, 0.0) * (previousDiscountFactor * previousSurvivalProbabilityFactor - discountFactor * survivalProbabilityFactor) * hazardRateFactor / (hazardRateFactor + forwardInterestRateFactor);
                        }
                        continue block7;
                    }
                    value += -feePayment * periodLength * discountFactor * survivalProbabilityFactor;
                    value += -feePayment * periodLength * previousDiscountFactor * previousSurvivalProbabilityFactor * accruedFactorJPM;
                    value += Math.max(1.0 - recoveryRate, 0.0) * (previousDiscountFactor * previousSurvivalProbabilityFactor - discountFactor * survivalProbabilityFactor) * hazardRateFactor / (hazardRateFactor + forwardInterestRateFactor);
                    continue block7;
                }
                case JPM_NOACCFEE: {
                    double subPeriodEndTime;
                    double subPeriodStartTime;
                    int subTimeIndex;
                    int endIndex;
                    int startIndex;
                    if (this.useFinerDiscretization) {
                        value += -feePayment * periodLength * discountFactor * survivalProbabilityFactor;
                        startIndex = Arrays.binarySearch(jointTimeDiscretization, (Object)periodStartTime);
                        endIndex = Arrays.binarySearch(jointTimeDiscretization, (Object)periodEndTime);
                        for (subTimeIndex = startIndex; subTimeIndex < endIndex; ++subTimeIndex) {
                            subPeriodStartTime = (Double)jointTimeDiscretization[subTimeIndex];
                            subPeriodEndTime = (Double)jointTimeDiscretization[subTimeIndex + 1];
                            discountFactor = discountCurve.getDiscountFactor(model, subPeriodEndTime);
                            previousDiscountFactor = discountCurve.getDiscountFactor(model, subPeriodStartTime);
                            survivalProbabilityFactor = survivalProbabilityCurve.getValue(model, subPeriodEndTime);
                            previousSurvivalProbabilityFactor = survivalProbabilityCurve.getValue(model, subPeriodStartTime);
                            forwardInterestRateFactor = (Math.log(discountCurve.getValue(model, subPeriodStartTime)) - Math.log(discountCurve.getValue(model, subPeriodEndTime))) / (subPeriodEndTime - subPeriodStartTime);
                            hazardRateFactor = (Math.log(survivalProbabilityCurve.getValue(model, subPeriodStartTime)) - Math.log(survivalProbabilityCurve.getValue(model, subPeriodEndTime))) / (subPeriodEndTime - subPeriodStartTime);
                            value += Math.max(1.0 - recoveryRate, 0.0) * (previousDiscountFactor * previousSurvivalProbabilityFactor - discountFactor * survivalProbabilityFactor) * hazardRateFactor / (hazardRateFactor + forwardInterestRateFactor);
                        }
                        continue block7;
                    }
                    value += -feePayment * periodLength * discountFactor * survivalProbabilityFactor;
                    value += Math.max(1.0 - recoveryRate, 0.0) * (previousDiscountFactor * previousSurvivalProbabilityFactor - discountFactor * survivalProbabilityFactor) * hazardRateFactor / (hazardRateFactor + forwardInterestRateFactor);
                    continue block7;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown valuation model: " + this.valuationModel);
                }
            }
        }
        return value / discountCurve.getDiscountFactor(model, evaluationTime);
    }

    public double getConventionalSpread(double evaluationTime, AnalyticModel calibratedModelJPM) {
        ForwardCurve forwardCurveInterpolation = calibratedModelJPM.getForwardCurve(this.forwardCurveName);
        if (forwardCurveInterpolation == null && this.forwardCurveName != null && this.forwardCurveName.length() > 0) {
            throw new IllegalArgumentException("No forward curve with name '" + this.forwardCurveName + "' was found in the model:\n" + calibratedModelJPM.toString());
        }
        DiscountCurve discountCurveInterpolation = calibratedModelJPM.getDiscountCurve(this.discountCurveName);
        if (discountCurveInterpolation == null) {
            throw new IllegalArgumentException("No discount curve with name '" + this.discountCurveName + "' was found in the model:\n" + calibratedModelJPM.toString());
        }
        Curve survivalProbabilityCurve = calibratedModelJPM.getCurve(this.survivalProbabilityCurveName);
        if (survivalProbabilityCurve == null) {
            throw new IllegalArgumentException("No survival probability curve with name '" + this.survivalProbabilityCurveName + "' was found in the model:\n" + calibratedModelJPM.toString());
        }
        Curve recoveryRateCurve = calibratedModelJPM.getCurve(this.recoveryRateCurveName);
        if (recoveryRateCurve == null) {
            throw new IllegalArgumentException("No recovery rate curve with name '" + this.recoveryRateCurveName + "' was found in the model:\n" + calibratedModelJPM.toString());
        }
        double valueFloatingLeg = 0.0;
        double valueFixedLeg = 0.0;
        for (int periodIndex = 0; periodIndex < this.schedule.getNumberOfPeriods(); ++periodIndex) {
            double paymentDate = this.schedule.getPayment(periodIndex);
            double periodLength = this.schedule.getPeriodLength(periodIndex);
            double discountFactor = paymentDate > evaluationTime ? discountCurveInterpolation.getDiscountFactor(calibratedModelJPM, paymentDate) : 0.0;
            double survivalProbabilityFactor = paymentDate > evaluationTime ? survivalProbabilityCurve.getValue(calibratedModelJPM, paymentDate) : 0.0;
            valueFixedLeg += periodLength * discountFactor * survivalProbabilityFactor;
            double previousPaymentDate = 0.0;
            if (periodIndex > 0) {
                previousPaymentDate = this.schedule.getPayment(periodIndex - 1);
            }
            double previousSurvivalProbabilityFactor = previousPaymentDate > evaluationTime ? survivalProbabilityCurve.getValue(calibratedModelJPM, previousPaymentDate) : 1.0;
            valueFloatingLeg += (1.0 - recoveryRateCurve.getValue(calibratedModelJPM, paymentDate)) * discountFactor * (previousSurvivalProbabilityFactor - survivalProbabilityFactor);
        }
        double conventionalSpread = valueFloatingLeg / valueFixedLeg;
        return conventionalSpread;
    }

    public double getFeePayment(int periodIndex, AnalyticModel model) {
        ForwardCurve forwardCurveInterpolation = model.getForwardCurve(this.forwardCurveName);
        if (forwardCurveInterpolation == null && this.forwardCurveName != null && this.forwardCurveName.length() > 0) {
            throw new IllegalArgumentException("No forward curve with name '" + this.forwardCurveName + "' was found in the model:\n" + model.toString());
        }
        double periodLength = this.schedule.getPeriodLength(periodIndex);
        double couponPayment = this.fixedFee;
        if (forwardCurveInterpolation != null) {
            couponPayment = this.floatingFeeSpread + forwardCurveInterpolation.getForward(model, this.schedule.getFixing(periodIndex));
        }
        return couponPayment * periodLength;
    }

    public double getAccruedFee(LocalDate date, AnalyticModel model) {
        int periodIndex = this.schedule.getPeriodIndex(date);
        Period period = this.schedule.getPeriod(periodIndex);
        DayCountConvention dcc = this.schedule.getDaycountconvention();
        double accruedFee = this.getFeePayment(periodIndex, model) * dcc.getDaycountFraction(period.getPeriodStart(), date) / this.schedule.getPeriodLength(periodIndex);
        return accruedFee;
    }

    public double getAccruedFee(double time, AnalyticModelFromCurvesAndVols model) {
        LocalDate date = FloatingpointDate.getDateFromFloatingPointDate(this.schedule.getReferenceDate(), time);
        return this.getAccruedFee(date, (AnalyticModel)model);
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public String getDiscountCurveName() {
        return this.discountCurveName;
    }

    public String getForwardCurveName() {
        return this.forwardCurveName;
    }

    public String getSurvivalProbabilityCurveName() {
        return this.survivalProbabilityCurveName;
    }

    public String getRecoveryRateCurveName() {
        return this.recoveryRateCurveName;
    }

    public double getFixedFee() {
        return this.fixedFee;
    }

    public double getFloatingFeeSpread() {
        return this.floatingFeeSpread;
    }

    public double getUpfrontPayment() {
        return this.upfrontPayment;
    }

    public LocalDate getTradeDate() {
        return this.tradeDate;
    }

    public ValuationModel getValuationModel() {
        return this.valuationModel;
    }

    public DirtyCleanPrice getDirtyCleanPrice() {
        return this.dirtyCleanPrice;
    }

    public boolean isUseFinerDiscretization() {
        return this.useFinerDiscretization;
    }

    public String toString() {
        return "CouponBond [ScheduleFromPeriods=" + this.schedule + ", discountCurveName=" + this.discountCurveName + ", forwardCurveName=" + this.forwardCurveName + ", survivalProbabilityCurveName=" + this.survivalProbabilityCurveName + ", recoveryRateCurve=" + this.recoveryRateCurveName + ", fixedFee=" + this.fixedFee + ", floatingFeeSpread=" + this.floatingFeeSpread + ", upfrontPayment=" + this.upfrontPayment + ", tradeDate=" + this.tradeDate + ", pricingModel=" + this.valuationModel + ", dirtyCleanPrice=" + this.dirtyCleanPrice + ", useFinerDiscretization=" + this.useFinerDiscretization + "]";
    }

    public static enum DirtyCleanPrice {
        CLEAN,
        DIRTY;

    }

    public static enum ValuationModel {
        DISCRETE,
        JPM,
        JPM_NOACCFEE;

    }
}

