/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import java.time.LocalDate;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.CurveBuilder;
import net.finmath.marketdata.model.curves.DiscountCurve;

public class DiscountCurveFromProductOfCurves
extends AbstractCurve
implements Serializable,
DiscountCurve {
    private static final long serialVersionUID = 6643801855646089707L;
    private final String[] curveNames;
    private final DiscountCurve[] curves;

    public DiscountCurveFromProductOfCurves(String name, LocalDate referenceDate, String ... curveNames) {
        super(name, referenceDate);
        this.curveNames = curveNames;
        this.curves = null;
    }

    public DiscountCurveFromProductOfCurves(String name, LocalDate referenceDate, DiscountCurve ... curves) {
        super(name, referenceDate);
        this.curveNames = null;
        this.curves = curves;
    }

    @Override
    public double getDiscountFactor(double maturity) {
        return this.getDiscountFactor(null, maturity);
    }

    @Override
    public double getDiscountFactor(AnalyticModel model, double maturity) {
        double discountFactor = 1.0;
        if (this.curveNames != null) {
            if (model == null) {
                throw new IllegalArgumentException("This object requires that a reference to an AnalyticModel is passed to a call this method.");
            }
            for (String curveName : this.curveNames) {
                discountFactor *= model.getDiscountCurve(curveName).getDiscountFactor(model, maturity);
            }
        } else {
            for (DiscountCurve curve : this.curves) {
                discountFactor *= curve.getDiscountFactor(model, maturity);
            }
        }
        return discountFactor;
    }

    @Override
    public double getValue(AnalyticModel model, double time) {
        return this.getDiscountFactor(model, time);
    }

    @Override
    public double[] getParameter() {
        return null;
    }

    @Override
    public void setParameter(double[] parameter) {
    }

    @Override
    public CurveBuilder getCloneBuilder() {
        return null;
    }
}

