/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveBuilder;
import net.finmath.marketdata.model.curves.DiscountCurve;

public class DiscountCurveNelsonSiegelSvensson
extends AbstractCurve
implements Serializable,
DiscountCurve {
    private static final long serialVersionUID = 8024640795839972709L;
    private final double timeScaling;
    private final double[] parameter;

    public DiscountCurveNelsonSiegelSvensson(String name, LocalDate referenceDate, double[] parameter, double timeScaling) {
        super(name, referenceDate);
        this.timeScaling = timeScaling;
        this.parameter = (double[])parameter.clone();
    }

    @Override
    public double getDiscountFactor(double maturity) {
        return this.getDiscountFactor(null, maturity);
    }

    @Override
    public double getDiscountFactor(AnalyticModel model, double maturity) {
        double y1;
        double x2;
        maturity *= this.timeScaling;
        double beta1 = this.parameter[0];
        double beta2 = this.parameter[1];
        double beta3 = this.parameter[2];
        double beta4 = this.parameter[3];
        double tau1 = this.parameter[4];
        double tau2 = this.parameter[5];
        double x1 = tau1 > 0.0 ? Math.exp(-maturity / tau1) : 0.0;
        double d = x2 = tau2 > 0.0 ? Math.exp(-maturity / tau2) : 0.0;
        double d2 = tau1 > 0.0 ? (maturity > 0.0 ? (1.0 - x1) / maturity * tau1 : 1.0) : (y1 = 0.0);
        double y2 = tau2 > 0.0 ? (maturity > 0.0 ? (1.0 - x2) / maturity * tau2 : 1.0) : 0.0;
        double zeroRate = beta1 + beta2 * y1 + beta3 * (y1 - x1) + beta4 * (y2 - x2);
        return Math.exp(-zeroRate * maturity);
    }

    @Override
    public double getValue(AnalyticModel model, double time) {
        return this.getDiscountFactor(model, time);
    }

    public double getZeroRate(double maturity) {
        if (maturity == 0.0) {
            return this.getZeroRate(1.0E-14);
        }
        return -Math.log(this.getDiscountFactor(null, maturity)) / maturity;
    }

    public double[] getZeroRates(double[] maturities) {
        double[] values = new double[maturities.length];
        for (int i = 0; i < maturities.length; ++i) {
            values[i] = this.getZeroRate(maturities[i]);
        }
        return values;
    }

    @Override
    public CurveBuilder getCloneBuilder() {
        return new CurveBuilder(){

            @Override
            public Curve build() {
                return DiscountCurveNelsonSiegelSvensson.this;
            }

            @Override
            public CurveBuilder addPoint(double time, double value, boolean isParameter) {
                return this;
            }
        };
    }

    @Override
    public double[] getParameter() {
        return this.parameter;
    }

    @Override
    @Deprecated
    public void setParameter(double[] parameter) {
        throw new UnsupportedOperationException();
    }

    public double getTimeScaling() {
        return this.timeScaling;
    }

    @Override
    public DiscountCurveNelsonSiegelSvensson clone() throws CloneNotSupportedException {
        return (DiscountCurveNelsonSiegelSvensson)super.clone();
    }

    @Override
    public DiscountCurveNelsonSiegelSvensson getCloneForParameter(double[] value) throws CloneNotSupportedException {
        return new DiscountCurveNelsonSiegelSvensson(this.getName(), this.getReferenceDate(), value, this.timeScaling);
    }

    @Override
    public String toString() {
        return "DiscountCurveNelsonSiegelSvensson [timeScaling=" + this.timeScaling + ", parameter=" + Arrays.toString(this.parameter) + ", toString()=" + super.toString() + "]";
    }
}

