/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.LocalDate;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveBuilder;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.time.FloatingpointDate;

public class DiscountCurveRenormalized
implements DiscountCurve,
Serializable {
    private static final long serialVersionUID = -7603795467908495733L;
    private final String name;
    private final LocalDate referenceDate;
    private final LocalDate spotDate;
    private final String baseCurveName;
    private transient double spotOffset;

    public DiscountCurveRenormalized(String name, LocalDate referenceDate, LocalDate spotDate, String baseCurveName) {
        this.name = name;
        this.referenceDate = referenceDate;
        this.spotDate = spotDate;
        this.baseCurveName = baseCurveName;
        this.spotOffset = FloatingpointDate.getFloatingPointDateFromDate(referenceDate, spotDate);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    @Override
    public double getValue(double time) {
        return this.getDiscountFactor(time);
    }

    @Override
    public double getValue(AnalyticModel model, double time) {
        return this.getDiscountFactor(model, time);
    }

    @Override
    public CurveBuilder getCloneBuilder() {
        throw new UnsupportedOperationException("Method not supported.");
    }

    @Override
    public Curve getCloneForParameter(double[] value) throws CloneNotSupportedException {
        throw new UnsupportedOperationException("Method not supported.");
    }

    @Override
    public double[] getParameter() {
        throw new UnsupportedOperationException("Method not supported.");
    }

    @Override
    public void setParameter(double[] parameter) {
        throw new UnsupportedOperationException("Method not supported.");
    }

    @Override
    public double getDiscountFactor(double maturity) {
        return this.getDiscountFactor(null, maturity);
    }

    @Override
    public double getDiscountFactor(AnalyticModel model, double maturity) {
        return model.getDiscountCurve(this.baseCurveName).getDiscountFactor(model, maturity) / model.getDiscountCurve(this.baseCurveName).getDiscountFactor(model, this.spotOffset);
    }

    @Override
    public DiscountCurveRenormalized clone() {
        return new DiscountCurveRenormalized(this.getName(), this.getReferenceDate(), this.spotDate, this.baseCurveName);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.spotOffset = FloatingpointDate.getFloatingPointDateFromDate(this.referenceDate, this.spotDate);
    }
}

