/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.logging.Logger;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.AbstractForwardCurve;
import net.finmath.marketdata.model.curves.CurveInterpolation;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingWeekends;

public class ForwardCurveInterpolation
extends AbstractForwardCurve
implements Serializable {
    private static final long serialVersionUID = -4126228588123963885L;
    private static Logger logger = Logger.getLogger("net.finmath");
    private InterpolationEntityForward interpolationEntityForward = InterpolationEntityForward.FORWARD;

    public ForwardCurveInterpolation(String name, LocalDate referenceDate, String paymentOffsetCode, BusinessdayCalendar paymentBusinessdayCalendar, BusinessdayCalendar.DateRollConvention paymentDateRollConvention, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity, InterpolationEntityForward interpolationEntityForward, String discountCurveName) {
        super(name, referenceDate, paymentOffsetCode, paymentBusinessdayCalendar, paymentDateRollConvention, interpolationMethod, extrapolationMethod, interpolationEntity, discountCurveName);
        this.interpolationEntityForward = interpolationEntityForward;
        if (interpolationEntityForward == InterpolationEntityForward.DISCOUNTFACTOR) {
            super.addPoint(0.0, 1.0, false);
        }
    }

    public ForwardCurveInterpolation(String name, LocalDate referenceDate, String paymentOffsetCode, InterpolationEntityForward interpolationEntityForward, String discountCurveName) {
        this(name, referenceDate, paymentOffsetCode, new BusinessdayCalendarExcludingWeekends(), BusinessdayCalendar.DateRollConvention.FOLLOWING, CurveInterpolation.InterpolationMethod.LINEAR, CurveInterpolation.ExtrapolationMethod.CONSTANT, CurveInterpolation.InterpolationEntity.VALUE, interpolationEntityForward, discountCurveName);
    }

    public ForwardCurveInterpolation(String name, LocalDate referenceDate, String paymentOffsetCode, String discountCurveName) {
        this(name, referenceDate, paymentOffsetCode, InterpolationEntityForward.FORWARD, discountCurveName);
    }

    public ForwardCurveInterpolation(String name, double paymentOffset, InterpolationEntityForward interpolationEntityForward, String discountCurveName) {
        super(name, null, paymentOffset, discountCurveName);
        this.interpolationEntityForward = interpolationEntityForward;
    }

    public static ForwardCurveInterpolation createForwardCurveFromForwards(String name, LocalDate referenceDate, String paymentOffsetCode, BusinessdayCalendar paymentBusinessdayCalendar, BusinessdayCalendar.DateRollConvention paymentDateRollConvention, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity, InterpolationEntityForward interpolationEntityForward, String discountCurveName, AnalyticModel model, double[] times, double[] givenForwards) {
        ForwardCurveInterpolation forwardCurveInterpolation = new ForwardCurveInterpolation(name, referenceDate, paymentOffsetCode, paymentBusinessdayCalendar, paymentDateRollConvention, interpolationMethod, extrapolationMethod, interpolationEntity, interpolationEntityForward, discountCurveName);
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            forwardCurveInterpolation.addForward(model, times[timeIndex], givenForwards[timeIndex], false);
        }
        return forwardCurveInterpolation;
    }

    public static ForwardCurveInterpolation createForwardCurveFromForwards(String name, Date referenceDate, String paymentOffsetCode, BusinessdayCalendar paymentBusinessdayCalendar, BusinessdayCalendar.DateRollConvention paymentDateRollConvention, CurveInterpolation.InterpolationMethod interpolationMethod, CurveInterpolation.ExtrapolationMethod extrapolationMethod, CurveInterpolation.InterpolationEntity interpolationEntity, InterpolationEntityForward interpolationEntityForward, String discountCurveName, AnalyticModel model, double[] times, double[] givenForwards) {
        return ForwardCurveInterpolation.createForwardCurveFromForwards(name, referenceDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), paymentOffsetCode, paymentBusinessdayCalendar, paymentDateRollConvention, interpolationMethod, extrapolationMethod, interpolationEntity, interpolationEntityForward, discountCurveName, model, times, givenForwards);
    }

    public static ForwardCurveInterpolation createForwardCurveFromForwards(String name, LocalDate referenceDate, String paymentOffsetCode, String interpolationEntityForward, String discountCurveName, AnalyticModel model, double[] times, double[] givenForwards) {
        return ForwardCurveInterpolation.createForwardCurveFromForwards(name, referenceDate, paymentOffsetCode, InterpolationEntityForward.valueOf(interpolationEntityForward), discountCurveName, model, times, givenForwards);
    }

    public static ForwardCurveInterpolation createForwardCurveFromForwards(String name, LocalDate referenceDate, String paymentOffsetCode, InterpolationEntityForward interpolationEntityForward, String discountCurveName, AnalyticModel model, double[] times, double[] givenForwards) {
        ForwardCurveInterpolation forwardCurveInterpolation = new ForwardCurveInterpolation(name, referenceDate, paymentOffsetCode, interpolationEntityForward, discountCurveName);
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            forwardCurveInterpolation.addForward(model, times[timeIndex], givenForwards[timeIndex], false);
        }
        return forwardCurveInterpolation;
    }

    public static ForwardCurveInterpolation createForwardCurveFromForwards(String name, double[] times, double[] givenForwards, double paymentOffset) {
        ForwardCurveInterpolation forwardCurveInterpolation = new ForwardCurveInterpolation(name, paymentOffset, InterpolationEntityForward.FORWARD, null);
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            double fixingTime = times[timeIndex];
            boolean isParameter = fixingTime > 0.0;
            forwardCurveInterpolation.addForward(null, fixingTime, givenForwards[timeIndex], isParameter);
        }
        return forwardCurveInterpolation;
    }

    public static ForwardCurveInterpolation createForwardCurveFromDiscountFactors(String name, double[] times, double[] givenDiscountFactors, double paymentOffset) {
        ForwardCurveInterpolation forwardCurveInterpolation = new ForwardCurveInterpolation(name, paymentOffset, InterpolationEntityForward.FORWARD, null);
        if (times.length == 0) {
            throw new IllegalArgumentException("Vector of times must not be empty.");
        }
        if (times[0] > 0.0) {
            double forward = (1.0 / givenDiscountFactors[0] - 1.0) / (times[0] - 0.0);
            forwardCurveInterpolation.addForward(null, 0.0, forward, true);
        }
        for (int timeIndex = 0; timeIndex < times.length - 1; ++timeIndex) {
            double forward = (givenDiscountFactors[timeIndex] / givenDiscountFactors[timeIndex + 1] - 1.0) / (times[timeIndex + 1] - times[timeIndex]);
            double fixingTime = times[timeIndex];
            boolean isParameter = fixingTime > 0.0;
            forwardCurveInterpolation.addForward(null, fixingTime, forward, isParameter);
        }
        return forwardCurveInterpolation;
    }

    public static ForwardCurveInterpolation createForwardCurveFromForwards(String name, double[] times, double[] givenForwards, AnalyticModel model, String discountCurveName, double paymentOffset) {
        ForwardCurveInterpolation forwardCurveInterpolation = new ForwardCurveInterpolation(name, paymentOffset, InterpolationEntityForward.FORWARD, discountCurveName);
        for (int timeIndex = 0; timeIndex < times.length; ++timeIndex) {
            double fixingTime = times[timeIndex];
            boolean isParameter = fixingTime > 0.0;
            forwardCurveInterpolation.addForward(model, fixingTime, givenForwards[timeIndex], isParameter);
        }
        return forwardCurveInterpolation;
    }

    @Override
    public double getForward(AnalyticModel model, double fixingTime) {
        double paymentOffset = this.getPaymentOffset(fixingTime);
        double interpolationEntityForwardValue = this.getValue(model, fixingTime);
        switch (this.interpolationEntityForward) {
            default: {
                return interpolationEntityForwardValue;
            }
            case FORWARD_TIMES_DISCOUNTFACTOR: {
                if (model == null) {
                    throw new IllegalArgumentException("model==null. Not allowed for interpolationEntityForward " + this.interpolationEntityForward);
                }
                return interpolationEntityForwardValue / model.getDiscountCurve(this.getDiscountCurveName()).getValue(model, fixingTime + paymentOffset);
            }
            case ZERO: {
                double interpolationEntityForwardValue2 = this.getValue(model, fixingTime + paymentOffset);
                return (Math.exp(interpolationEntityForwardValue2 * (fixingTime + paymentOffset) - interpolationEntityForwardValue * fixingTime) - 1.0) / paymentOffset;
            }
            case DISCOUNTFACTOR: 
        }
        double interpolationEntityForwardValue2 = this.getValue(model, fixingTime + paymentOffset);
        return (interpolationEntityForwardValue / interpolationEntityForwardValue2 - 1.0) / paymentOffset;
    }

    @Override
    public double getForward(AnalyticModel model, double fixingTime, double paymentOffset) {
        double forward = this.getForward(model, fixingTime);
        double curvePaymentOffset = this.getPaymentOffset(fixingTime);
        if (paymentOffset != curvePaymentOffset) {
            forward = (Math.exp(Math.log(1.0 + forward * curvePaymentOffset) * paymentOffset / curvePaymentOffset) - 1.0) / paymentOffset;
        }
        return forward;
    }

    private void addForward(AnalyticModel model, double fixingTime, double forward, boolean isParameter) {
        double interpolationEntityForwardValue;
        double interpolationEntitiyTime;
        switch (this.interpolationEntityForward) {
            default: {
                interpolationEntitiyTime = fixingTime;
                interpolationEntityForwardValue = forward;
                break;
            }
            case FORWARD_TIMES_DISCOUNTFACTOR: {
                interpolationEntitiyTime = fixingTime;
                interpolationEntityForwardValue = forward * model.getDiscountCurve(this.getDiscountCurveName()).getValue(model, fixingTime + this.getPaymentOffset(fixingTime));
                break;
            }
            case ZERO: {
                double paymentOffset = this.getPaymentOffset(fixingTime);
                interpolationEntitiyTime = fixingTime + paymentOffset;
                interpolationEntityForwardValue = Math.log(1.0 + forward * paymentOffset) / paymentOffset;
                break;
            }
            case DISCOUNTFACTOR: {
                double paymentOffset = this.getPaymentOffset(fixingTime);
                interpolationEntitiyTime = fixingTime + paymentOffset;
                interpolationEntityForwardValue = this.getValue(fixingTime) / (1.0 + forward * paymentOffset);
                break;
            }
        }
        super.addPoint(interpolationEntitiyTime, interpolationEntityForwardValue, isParameter);
    }

    @Override
    protected void addPoint(double time, double value, boolean isParameter) {
        if (this.interpolationEntityForward == InterpolationEntityForward.DISCOUNTFACTOR) {
            time += this.getPaymentOffset(time);
        }
        super.addPoint(time, value, isParameter);
    }

    public InterpolationEntityForward getInterpolationEntityForward() {
        return this.interpolationEntityForward;
    }

    @Override
    public String toString() {
        return "ForwardCurve [" + super.toString() + ", interpolationEntityForward=" + this.interpolationEntityForward + "]";
    }

    public static enum InterpolationEntityForward {
        FORWARD,
        FORWARD_TIMES_DISCOUNTFACTOR,
        ZERO,
        DISCOUNTFACTOR;

    }
}

