/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.curves;

import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveBuilder;
import net.finmath.marketdata.model.curves.DiscountCurve;

public class IndexCurveFromDiscountCurve
extends AbstractCurve
implements Curve {
    private static final long serialVersionUID = -3760460344256117452L;
    private final double indexValue;
    private final DiscountCurve discountCurve;

    public IndexCurveFromDiscountCurve(String name, double indexValue, DiscountCurve discountCurve) {
        super(name, discountCurve.getReferenceDate());
        this.indexValue = indexValue;
        this.discountCurve = discountCurve;
    }

    @Override
    public double[] getParameter() {
        return this.discountCurve.getParameter();
    }

    @Override
    public void setParameter(double[] parameter) {
        this.discountCurve.setParameter(parameter);
    }

    @Override
    public double getValue(AnalyticModel model, double time) {
        return this.indexValue / this.discountCurve.getDiscountFactor(model, time);
    }

    @Override
    public CurveBuilder getCloneBuilder() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

