/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.curves.CurveInterpolation;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.volatilities.AbstractVolatilitySurface;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;

public class CapletVolatilities
extends AbstractVolatilitySurface {
    private final Map<Double, Curve> capletVolatilities = new HashMap<Double, Curve>();
    private transient Double[] maturities;
    private transient Object lazyInitLock = new Object();

    public CapletVolatilities(String name, LocalDate referenceDate, ForwardCurve forwardCurve, double[] maturities, double[] strikes, double[] volatilities, VolatilitySurface.QuotingConvention volatilityConvention, DiscountCurve discountCurve) {
        super(name, referenceDate, forwardCurve, discountCurve, volatilityConvention, null);
        if (maturities.length != strikes.length || maturities.length != volatilities.length) {
            throw new IllegalArgumentException("Length of vectors is not equal.");
        }
        for (int i = 0; i < volatilities.length; ++i) {
            double maturity = maturities[i];
            double strike = strikes[i];
            double volatility = volatilities[i];
            this.add(maturity, strike, volatility);
        }
    }

    private CapletVolatilities(String name, LocalDate referenceDate) {
        super(name, referenceDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(double maturity, double strike, double volatility) {
        Curve curve = this.capletVolatilities.get(maturity);
        try {
            curve = curve == null ? new CurveInterpolation.Builder().addPoint(strike, volatility, true).build() : curve.getCloneBuilder().addPoint(strike, volatility, true).build();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Unable to build curve.");
        }
        Object object = this.lazyInitLock;
        synchronized (object) {
            this.capletVolatilities.put(maturity, curve);
            this.maturities = null;
        }
    }

    @Override
    public double getValue(double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        return this.getValue(null, maturity, strike, quotingConvention);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getValue(AnalyticModel model, double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        double value;
        if (maturity == 0.0) {
            return 0.0;
        }
        if (this.capletVolatilities.containsKey(maturity)) {
            value = this.capletVolatilities.get(maturity).getValue(strike);
        } else {
            Object object = this.lazyInitLock;
            synchronized (object) {
                if (this.maturities == null) {
                    this.maturities = this.capletVolatilities.keySet().toArray(new Double[0]);
                }
                Arrays.sort((Object[])this.maturities);
            }
            int maturityGreaterEqualIndex = Arrays.binarySearch((Object[])this.maturities, (Object)maturity);
            if (maturityGreaterEqualIndex < 0) {
                maturityGreaterEqualIndex = -maturityGreaterEqualIndex - 1;
            }
            if (maturityGreaterEqualIndex > this.maturities.length - 1) {
                maturityGreaterEqualIndex = this.maturities.length - 1;
            }
            double maturityGreaterOfEqual = this.maturities[maturityGreaterEqualIndex];
            double adjustedStrike = this.getForwardCurve().getValue(model, maturityGreaterOfEqual) + (strike - this.getForwardCurve().getValue(model, maturity));
            value = this.capletVolatilities.get(maturityGreaterOfEqual).getValue(adjustedStrike);
        }
        return this.convertFromTo(model, maturity, strike, value, this.getQuotingConvention(), quotingConvention);
    }

    public static AbstractVolatilitySurface fromFile(File inputFile) throws FileNotFoundException {
        ArrayList<String> datasets = new ArrayList<String>();
        try (BufferedReader dataStream = new BufferedReader(new InputStreamReader(new FileInputStream(inputFile)));){
            String line;
            while ((line = dataStream.readLine()) != null) {
                if (!line.startsWith("caplet\t")) continue;
                datasets.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CapletVolatilities capletVolatilities = new CapletVolatilities(null, null);
        for (int datasetIndex = 0; datasetIndex < datasets.size(); ++datasetIndex) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)datasets.get(datasetIndex), "\t");
            try {
                stringTokenizer.nextToken();
                double maturity = Double.parseDouble(stringTokenizer.nextToken());
                double strike = Double.parseDouble(stringTokenizer.nextToken());
                double capletVolatility = Double.parseDouble(stringTokenizer.nextToken());
                capletVolatilities.add(maturity, strike, capletVolatility);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return capletVolatilities;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.lazyInitLock = new Object();
    }
}

