/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import java.time.LocalDate;
import java.util.function.DoubleUnaryOperator;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.volatilities.AbstractVolatilitySurfaceParametric;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;

public class CapletVolatilitiesParametric
extends AbstractVolatilitySurfaceParametric {
    private final double timeScaling;
    private final double a;
    private final double b;
    private final double c;
    private final double d;

    public CapletVolatilitiesParametric(String name, LocalDate referenceDate, ForwardCurve forwardCurve, DiscountCurve discountCurve, double a, double b, double c, double d, double timeScaling, VolatilitySurface.QuotingConvention quotingConvention) {
        super(name, referenceDate, forwardCurve, discountCurve, quotingConvention, null);
        this.timeScaling = timeScaling;
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public CapletVolatilitiesParametric(String name, LocalDate referenceDate, ForwardCurve forwardCurve, DiscountCurve discountCurve, double a, double b, double c, double d, double timeScaling) {
        super(name, referenceDate, forwardCurve, discountCurve, VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL, null);
        this.timeScaling = timeScaling;
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public CapletVolatilitiesParametric(String name, LocalDate referenceDate, double a, double b, double c, double d, double timeScaling) {
        this(name, referenceDate, null, null, a, b, c, d, timeScaling);
    }

    public CapletVolatilitiesParametric(String name, LocalDate referenceDate, double a, double b, double c, double d) {
        this(name, referenceDate, a, b, c, d, 1.0);
    }

    @Override
    public double getValue(double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        return this.getValue(null, maturity, strike, quotingConvention);
    }

    @Override
    public double getValue(AnalyticModel model, double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        double integratedVariance;
        if (maturity <= 0.0) {
            return 0.0;
        }
        double T = maturity * this.timeScaling;
        if (Math.abs(this.c * T) > 1.0E-5) {
            double u = Math.exp(-this.c * T);
            double u2 = Math.exp(-2.0 * this.c * T);
            DoubleUnaryOperator umxlogu = x -> (u - x) / Math.log(u);
            DoubleUnaryOperator u2mxlogu2 = x -> (u2 - x) / Math.log(u2);
            double expA1 = umxlogu.applyAsDouble(1.0);
            double expA2 = umxlogu.applyAsDouble(expA1) * 2.0;
            double expB1 = u2mxlogu2.applyAsDouble(1.0);
            double expB2 = u2mxlogu2.applyAsDouble(expB1) * 2.0;
            double expB3 = u2mxlogu2.applyAsDouble(expB2) * 3.0;
            integratedVariance = this.a * this.a * T * expB1 + this.a * this.b * T * T * expB2 + 2.0 * this.a * this.d * T * expA1 + this.b * this.b * T * T * T * expB3 / 3.0 + this.b * this.d * T * T * expA2 + this.d * this.d * T;
        } else {
            integratedVariance = this.a * this.a * T + this.a * this.b * T * T + 2.0 * this.a * this.d * T + this.b * this.b * T * T * T / 3.0 + this.b * this.d * T * T + this.d * this.d * T;
        }
        double value = Math.sqrt(integratedVariance / maturity);
        return this.convertFromTo(model, maturity, strike, value, this.getQuotingConvention(), quotingConvention);
    }

    @Override
    public double[] getParameter() {
        double[] parameter = new double[]{this.a, this.b, this.c, this.d};
        return parameter;
    }

    @Override
    public void setParameter(double[] parameter) {
        throw new UnsupportedOperationException("This class is immutable.");
    }

    @Override
    public AbstractVolatilitySurfaceParametric getCloneForParameter(double[] value) throws CloneNotSupportedException {
        return new CapletVolatilitiesParametric(this.getName(), this.getReferenceDate(), this.getForwardCurve(), this.getDiscountCurve(), value[0], value[1], value[2], value[3], this.timeScaling, this.getQuotingConvention());
    }
}

