/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import java.time.LocalDate;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.volatilities.AbstractVolatilitySurfaceParametric;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.time.TimeDiscretization;

public class CapletVolatilitiesParametricFourParameterPicewiseConstant
extends AbstractVolatilitySurfaceParametric {
    private final double a;
    private final double b;
    private final double c;
    private final double d;
    private final TimeDiscretization timeDiscretization;

    public CapletVolatilitiesParametricFourParameterPicewiseConstant(String name, LocalDate referenceDate, double a, double b, double c, double d, TimeDiscretization timeDiscretization) {
        super(name, referenceDate, null, null, VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL, null);
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.timeDiscretization = timeDiscretization;
    }

    @Override
    public double getValue(double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        return this.getValue(null, maturity, strike, quotingConvention);
    }

    @Override
    public double getValue(AnalyticModel model, double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        double time;
        if (maturity == 0.0) {
            return 0.0;
        }
        double integratedVariance = 0.0;
        for (int timeIndex = 0; timeIndex < this.timeDiscretization.getNumberOfTimeSteps() && !((time = this.timeDiscretization.getTime(timeIndex)) > maturity); ++timeIndex) {
            double timeStep = this.timeDiscretization.getTimeStep(timeIndex);
            double instantaneousVolatility = (this.a + this.b * (maturity - time)) * Math.exp(-this.c * (maturity - time)) + this.d;
            integratedVariance += instantaneousVolatility * instantaneousVolatility * Math.min(maturity - time, timeStep);
        }
        double value = Math.sqrt(integratedVariance / maturity);
        return this.convertFromTo(model, maturity, strike, value, this.getQuotingConvention(), quotingConvention);
    }

    @Override
    public double[] getParameter() {
        double[] parameter = new double[]{this.a, this.b, this.c, this.d};
        return parameter;
    }

    @Override
    public void setParameter(double[] parameter) {
        throw new UnsupportedOperationException("This class is immutable.");
    }

    @Override
    public AbstractVolatilitySurfaceParametric getCloneForParameter(double[] value) throws CloneNotSupportedException {
        return new CapletVolatilitiesParametricFourParameterPicewiseConstant(this.getName(), this.getReferenceDate(), value[0], value[1], value[2], value[3], this.timeDiscretization);
    }
}

