/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatilities;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import net.finmath.marketdata.model.volatilities.OptionData;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;

public class OptionSmileData {
    private final String underlying;
    private final LocalDate referenceDate;
    private final double[] strikes;
    private final double maturity;
    private final HashMap<Double, OptionData> smile;

    public OptionSmileData(String underlying, LocalDate referenceDate, double[] strikes, double maturity, double[] values, VolatilitySurface.QuotingConvention convention) {
        if (strikes.length != values.length) {
            throw new IllegalArgumentException("Number of strikes and market quotes does not coincide");
        }
        int numberOfQuotes = strikes.length;
        this.smile = new HashMap();
        for (int i = 0; i < numberOfQuotes; ++i) {
            this.smile.put(strikes[i], new OptionData(underlying, referenceDate, strikes[i], maturity, values[i], convention));
        }
        this.underlying = underlying;
        this.referenceDate = referenceDate;
        this.strikes = strikes;
        this.maturity = maturity;
    }

    public String getUnderlying() {
        return this.underlying;
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public double[] getStrikes() {
        return this.strikes;
    }

    public double getMaturity() {
        return this.maturity;
    }

    public HashMap<Double, OptionData> getSmile() {
        return this.smile;
    }

    public OptionData getOption(double strike) {
        return this.smile.get(strike);
    }

    public String toString() {
        return "EquityOptionSmile [underlying=" + this.underlying + ", strikes=" + Arrays.toString(this.strikes) + ", maturity=" + this.maturity + ", smile=" + this.smile + "]";
    }
}

