/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatility.caplet;

import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.marketdata.products.Cap;
import net.finmath.time.Schedule;

public class CapShiftedVol
extends Cap {
    private final double shift;
    private final Schedule schedule;
    private final boolean isStrikeMoneyness;
    private final String volatilitySurfaceName;

    public CapShiftedVol(Schedule schedule, String forwardCurveName, double strike, boolean isStrikeMoneyness, String discountCurveName, String volatilitySurfaceName, double shift) {
        super(schedule, forwardCurveName, strike, isStrikeMoneyness, discountCurveName, volatilitySurfaceName);
        this.shift = shift;
        this.schedule = schedule;
        this.isStrikeMoneyness = isStrikeMoneyness;
        this.volatilitySurfaceName = volatilitySurfaceName;
    }

    @Override
    public double getValueAsPrice(double evaluationTime, AnalyticModel model) {
        ForwardCurve forwardCurve = model.getForwardCurve(super.getForwardCurveName());
        DiscountCurve discountCurve = model.getDiscountCurve(super.getDiscountCurveName());
        DiscountCurve discountCurveForForward = null;
        if (forwardCurve == null && super.getForwardCurveName() != null && super.getForwardCurveName().length() > 0 && (discountCurveForForward = model.getDiscountCurve(super.getForwardCurveName())) == null) {
            throw new IllegalArgumentException("No curve of the name " + super.getForwardCurveName() + " was found in the model.");
        }
        double value = 0.0;
        for (int periodIndex = 0; periodIndex < this.schedule.getNumberOfPeriods(); ++periodIndex) {
            double volatility;
            VolatilitySurface volatilitySurface;
            double fixingDate = this.schedule.getFixing(periodIndex);
            double paymentDate = this.schedule.getPayment(periodIndex);
            double periodLength = this.schedule.getPeriodLength(periodIndex);
            if (periodLength == 0.0) continue;
            double forward = 0.0;
            if (forwardCurve != null) {
                forward += forwardCurve.getForward(model, fixingDate, paymentDate - fixingDate);
            } else if (discountCurveForForward != null && fixingDate != paymentDate) {
                forward += (discountCurveForForward.getDiscountFactor(fixingDate) / discountCurveForForward.getDiscountFactor(paymentDate) - 1.0) / (paymentDate - fixingDate);
            }
            double discountFactor = paymentDate > evaluationTime ? discountCurve.getDiscountFactor(model, paymentDate) : 0.0;
            double payoffUnit = discountFactor * periodLength;
            double effektiveStrike = super.getStrike();
            if (this.isStrikeMoneyness) {
                effektiveStrike += this.getATMForward(model, true);
            }
            if ((volatilitySurface = model.getVolatilitySurface(this.volatilitySurfaceName)) == null) {
                throw new IllegalArgumentException("Volatility surface not found in model: " + this.volatilitySurfaceName);
            }
            if (volatilitySurface.getQuotingConvention() == VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL) {
                volatility = volatilitySurface.getValue(model, fixingDate, effektiveStrike, VolatilitySurface.QuotingConvention.VOLATILITYLOGNORMAL);
                if (!(fixingDate >= (paymentDate - fixingDate) * 0.5) || volatility == 0.0) continue;
                value += AnalyticFormulas.blackScholesGeneralizedOptionValue(forward + this.shift, volatility, fixingDate, effektiveStrike + this.shift, payoffUnit);
                continue;
            }
            volatility = volatilitySurface.getValue(model, fixingDate, effektiveStrike, VolatilitySurface.QuotingConvention.VOLATILITYNORMAL);
            if (!(fixingDate >= (paymentDate - fixingDate) * 0.5) || volatility == 0.0) continue;
            value += AnalyticFormulas.bachelierOptionValue(forward + this.shift, volatility, fixingDate, effektiveStrike + this.shift, payoffUnit);
        }
        return value / discountCurve.getDiscountFactor(model, evaluationTime);
    }
}

