/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.model.volatility.caplet.smile;

import net.finmath.marketdata.model.volatility.caplet.smile.SmileInterpolationExtrapolationMethod;

public class LinearSmileInterpolater
implements SmileInterpolationExtrapolationMethod {
    private final double[][] volatilityMatrix;
    private final double[] strikeVector;

    public LinearSmileInterpolater(double[][] volatilityMatrix, double[] strikeVector) {
        this.volatilityMatrix = volatilityMatrix;
        this.strikeVector = strikeVector;
    }

    @Override
    public double calculateInterpolatedExtrapolatedSmileVolatility(double strike, int rowIndex) {
        if (strike < this.strikeVector[0]) {
            return this.volatilityMatrix[rowIndex][0];
        }
        if (strike >= this.strikeVector[this.strikeVector.length - 1]) {
            return this.volatilityMatrix[rowIndex][this.strikeVector.length - 1];
        }
        int indexLargestStrikeLeftOfInterpolationStrike = 0;
        int i = 0;
        while (strike >= this.strikeVector[i]) {
            indexLargestStrikeLeftOfInterpolationStrike = i++;
        }
        if (this.volatilityMatrix[rowIndex][indexLargestStrikeLeftOfInterpolationStrike + 1] == 0.0) {
            return this.volatilityMatrix[rowIndex][indexLargestStrikeLeftOfInterpolationStrike];
        }
        if (strike == this.strikeVector[indexLargestStrikeLeftOfInterpolationStrike]) {
            return this.volatilityMatrix[rowIndex][indexLargestStrikeLeftOfInterpolationStrike];
        }
        return (strike - this.strikeVector[indexLargestStrikeLeftOfInterpolationStrike]) * (this.volatilityMatrix[rowIndex][indexLargestStrikeLeftOfInterpolationStrike + 1] - this.volatilityMatrix[rowIndex][indexLargestStrikeLeftOfInterpolationStrike]) / (this.strikeVector[indexLargestStrikeLeftOfInterpolationStrike + 1] - this.strikeVector[indexLargestStrikeLeftOfInterpolationStrike]) + this.volatilityMatrix[rowIndex][indexLargestStrikeLeftOfInterpolationStrike];
    }
}

