/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata.products;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.IntToDoubleFunction;
import java.util.stream.IntStream;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.products.AbstractAnalyticProduct;
import net.finmath.marketdata.products.AnalyticProduct;

public class Portfolio
extends AbstractAnalyticProduct
implements AnalyticProduct {
    private final ArrayList<AnalyticProduct> products = new ArrayList();
    private final ArrayList<Double> weights = new ArrayList();

    public Portfolio(List<AnalyticProduct> products, List<Double> weights) {
        this.products.addAll(products);
        this.weights.addAll(weights);
    }

    public Portfolio(Portfolio portfolio, List<AnalyticProduct> products, List<Double> weights) {
        this.products.addAll(portfolio.getProducts());
        this.weights.addAll(portfolio.getWeights());
        this.products.addAll(products);
        this.weights.addAll(weights);
    }

    public Portfolio(AnalyticProduct product, double weight) {
        this.products.add(product);
        this.weights.add(weight);
    }

    public Portfolio(List<AnalyticProduct> products) {
        this(products, Collections.nCopies(products.size(), new Double(1.0)));
    }

    @Override
    public double getValue(final double evaluationTime, final AnalyticModel model) {
        return IntStream.range(0, this.products.size()).parallel().mapToDouble(new IntToDoubleFunction(){

            @Override
            public double applyAsDouble(int i) {
                return Portfolio.this.weights.get(i) * Portfolio.this.products.get(i).getValue(evaluationTime, model);
            }
        }).sum();
    }

    public List<AnalyticProduct> getProducts() {
        return Collections.unmodifiableList(this.products);
    }

    public List<Double> getWeights() {
        return Collections.unmodifiableList(this.weights);
    }
}

