/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.calibration;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.finmath.marketdata2.calibration.ParameterAggregation;
import net.finmath.marketdata2.calibration.ParameterObject;
import net.finmath.marketdata2.calibration.ParameterTransformation;
import net.finmath.marketdata2.model.AnalyticModel;
import net.finmath.marketdata2.products.AnalyticProduct;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.optimizer.SolverException;
import net.finmath.optimizer.StochasticOptimizer;
import net.finmath.optimizer.StochasticOptimizerFactory;
import net.finmath.optimizer.StochasticPathwiseOptimizerFactoryLevenbergMarquardt;
import net.finmath.stochastic.RandomVariable;

public class Solver {
    private final AnalyticModel model;
    private final List<AnalyticProduct> calibrationProducts;
    private final List<Double> calibrationTargetValues;
    private final double calibrationAccuracy;
    private final ParameterTransformation parameterTransformation;
    private StochasticOptimizerFactory optimizerFactory;
    private final double evaluationTime;
    private final int maxIterations = 1000;
    private int iterations = 0;
    private double accuracy = Double.POSITIVE_INFINITY;

    public Solver(AnalyticModel model, Vector<AnalyticProduct> calibrationProducts, List<Double> calibrationTargetValues, ParameterTransformation parameterTransformation, double evaluationTime, StochasticOptimizerFactory optimizerFactory) {
        this.model = model;
        this.calibrationProducts = calibrationProducts;
        this.calibrationTargetValues = calibrationTargetValues;
        this.parameterTransformation = parameterTransformation;
        this.evaluationTime = evaluationTime;
        this.optimizerFactory = optimizerFactory;
        this.calibrationAccuracy = 0.0;
    }

    public Solver(AnalyticModel model, Vector<AnalyticProduct> calibrationProducts, List<Double> calibrationTargetValues, ParameterTransformation parameterTransformation, double evaluationTime, double calibrationAccuracy) {
        this.model = model;
        this.calibrationProducts = calibrationProducts;
        this.calibrationTargetValues = calibrationTargetValues;
        this.parameterTransformation = parameterTransformation;
        this.evaluationTime = evaluationTime;
        this.calibrationAccuracy = calibrationAccuracy;
        this.optimizerFactory = null;
    }

    public Solver(AnalyticModel model, Vector<AnalyticProduct> calibrationProducts, List<Double> calibrationTargetValues, double evaluationTime, double calibrationAccuracy) {
        this(model, calibrationProducts, calibrationTargetValues, null, evaluationTime, calibrationAccuracy);
    }

    public Solver(AnalyticModel model, Vector<AnalyticProduct> calibrationProducts, double evaluationTime, double calibrationAccuracy) {
        this(model, calibrationProducts, null, null, evaluationTime, calibrationAccuracy);
    }

    public Solver(AnalyticModel model, Vector<AnalyticProduct> calibrationProducts) {
        this(model, calibrationProducts, 0.0, 0.0);
    }

    public AnalyticModel getCalibratedModel(Set<ParameterObject> objectsToCalibrate) throws SolverException {
        final ParameterAggregation<ParameterObject> parameterAggregate = new ParameterAggregation<ParameterObject>(objectsToCalibrate);
        RandomVariable[] initialParameters = this.parameterTransformation != null ? this.parameterTransformation.getSolverParameter(parameterAggregate.getParameter()) : parameterAggregate.getParameter();
        Object[] zeros = new RandomVariable[this.calibrationProducts.size()];
        Object[] ones = new RandomVariable[this.calibrationProducts.size()];
        Object[] lowerBound = new RandomVariable[initialParameters.length];
        Object[] upperBound = new RandomVariable[initialParameters.length];
        Arrays.fill(zeros, new RandomVariableFromDoubleArray(0.0));
        Arrays.fill(ones, new RandomVariableFromDoubleArray(1.0));
        Arrays.fill(lowerBound, new RandomVariableFromDoubleArray(Double.NEGATIVE_INFINITY));
        Arrays.fill(upperBound, new RandomVariableFromDoubleArray(Double.POSITIVE_INFINITY));
        StochasticOptimizer.ObjectiveFunction objectiveFunction = new StochasticOptimizer.ObjectiveFunction(){

            @Override
            public void setValues(RandomVariable[] parameters, RandomVariable[] values) throws SolverException {
                RandomVariable[] modelParameters = parameters;
                try {
                    int i;
                    if (Solver.this.parameterTransformation != null) {
                        modelParameters = Solver.this.parameterTransformation.getParameter(parameters);
                        System.arraycopy(Solver.this.parameterTransformation.getSolverParameter(modelParameters), 0, parameters, 0, parameters.length);
                    }
                    Map<ParameterObject, RandomVariable[]> curvesParameterPairs = parameterAggregate.getObjectsToModifyForParameter(modelParameters);
                    AnalyticModel modelClone = Solver.this.model.getCloneForParameter(curvesParameterPairs);
                    for (i = 0; i < Solver.this.calibrationProducts.size(); ++i) {
                        values[i] = Solver.this.calibrationProducts.get(i).getValue(Solver.this.evaluationTime, modelClone);
                    }
                    if (Solver.this.calibrationTargetValues != null) {
                        for (i = 0; i < Solver.this.calibrationTargetValues.size(); ++i) {
                            values[i].sub(Solver.this.calibrationTargetValues.get(i));
                        }
                    }
                }
                catch (CloneNotSupportedException e) {
                    throw new SolverException(e);
                }
            }
        };
        if (this.optimizerFactory == null) {
            int maxThreads = Math.min(2 * Math.max(Runtime.getRuntime().availableProcessors(), 1), initialParameters.length);
            this.optimizerFactory = new StochasticPathwiseOptimizerFactoryLevenbergMarquardt(1000, this.calibrationAccuracy, maxThreads);
        }
        StochasticOptimizer optimizer = this.optimizerFactory.getOptimizer(objectiveFunction, initialParameters, (RandomVariable[])lowerBound, (RandomVariable[])upperBound, (RandomVariable[])zeros);
        optimizer.run();
        this.iterations = optimizer.getIterations();
        RandomVariable[] bestParameters = optimizer.getBestFitParameters();
        if (this.parameterTransformation != null) {
            bestParameters = this.parameterTransformation.getParameter(bestParameters);
        }
        AnalyticModel calibratedModel = null;
        try {
            Map<ParameterObject, RandomVariable[]> curvesParameterPairs = parameterAggregate.getObjectsToModifyForParameter(bestParameters);
            calibratedModel = this.model.getCloneForParameter(curvesParameterPairs);
        }
        catch (CloneNotSupportedException e) {
            throw new SolverException(e);
        }
        this.accuracy = 0.0;
        for (int i = 0; i < this.calibrationProducts.size(); ++i) {
            double error = this.calibrationProducts.get(i).getValue(this.evaluationTime, calibratedModel).getStandardDeviation();
            if (this.calibrationTargetValues != null) {
                error -= this.calibrationTargetValues.get(i).doubleValue();
            }
            this.accuracy += error * error;
        }
        this.accuracy = Math.sqrt(this.accuracy / (double)this.calibrationProducts.size());
        return calibratedModel;
    }

    public int getIterations() {
        return this.iterations;
    }

    public double getAccuracy() {
        return this.accuracy;
    }
}

