/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.model.curves;

import java.io.Serializable;
import net.finmath.marketdata2.model.AnalyticModel;
import net.finmath.marketdata2.model.curves.AbstractCurve;
import net.finmath.marketdata2.model.curves.CurveBuilder;
import net.finmath.marketdata2.model.curves.DiscountCurveInterface;
import net.finmath.marketdata2.model.curves.ForwardCurveInterface;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.stochastic.RandomVariable;

public class DiscountCurveFromForwardCurve
extends AbstractCurve
implements Serializable,
DiscountCurveInterface {
    private static final long serialVersionUID = -4126228588123963885L;
    private String forwardCurveName;
    private ForwardCurveInterface forwardCurve;
    private final double timeScaling;

    public DiscountCurveFromForwardCurve(String forwardCurveName, double periodLengthTimeScaling) {
        super("DiscountCurveFromForwardCurve(" + forwardCurveName + ")", null);
        this.forwardCurveName = forwardCurveName;
        this.timeScaling = periodLengthTimeScaling;
    }

    public DiscountCurveFromForwardCurve(ForwardCurveInterface forwardCurve, double periodLengthTimeScaling) {
        super("DiscountCurveFromForwardCurve" + forwardCurve.getName() + ")", null);
        this.forwardCurve = forwardCurve;
        this.timeScaling = periodLengthTimeScaling;
    }

    public DiscountCurveFromForwardCurve(String forwardCurveName) {
        this(forwardCurveName, 1.0);
    }

    public DiscountCurveFromForwardCurve(ForwardCurveInterface forwardCurve) {
        this(forwardCurve, 1.0);
    }

    @Override
    public RandomVariable getDiscountFactor(double maturity) {
        return this.getDiscountFactor(null, maturity);
    }

    @Override
    public RandomVariable getDiscountFactor(AnalyticModel model, double maturity) {
        ForwardCurveInterface forwardCurve = this.forwardCurve != null ? this.forwardCurve : model.getForwardCurve(this.forwardCurveName);
        if (forwardCurve == null) {
            throw new IllegalArgumentException("No forward curve given and no forward curve found in the model under the name " + this.forwardCurveName + ".");
        }
        RandomVariable discountFactor = new RandomVariableFromDoubleArray(1.0);
        double paymentOffset = 0.0;
        for (double time = 0.0; time < maturity; time += paymentOffset) {
            paymentOffset = forwardCurve.getPaymentOffset(time);
            if (paymentOffset <= 0.0) {
                throw new RuntimeException("Trying to calculate a discount curve from a forward curve with non-positive payment offset.");
            }
            discountFactor = forwardCurve.getForward(model, time).mult(Math.min(paymentOffset, maturity - time) * this.timeScaling).add(1.0).pow(-1.0).mult(discountFactor);
        }
        return discountFactor;
    }

    @Override
    public RandomVariable getValue(AnalyticModel model, double time) {
        return this.getDiscountFactor(model, time);
    }

    @Override
    public RandomVariable[] getParameter() {
        return null;
    }

    @Override
    public void setParameter(RandomVariable[] parameter) {
    }

    @Override
    public CurveBuilder getCloneBuilder() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.forwardCurve == null ? 0 : this.forwardCurve.hashCode());
        result = 31 * result + (this.forwardCurveName == null ? 0 : this.forwardCurveName.hashCode());
        long temp = Double.doubleToLongBits(this.timeScaling);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscountCurveFromForwardCurve other = (DiscountCurveFromForwardCurve)obj;
        if (this.forwardCurve == null ? other.forwardCurve != null : !this.forwardCurve.equals(other.forwardCurve)) {
            return false;
        }
        if (this.forwardCurveName == null ? other.forwardCurveName != null : !this.forwardCurveName.equals(other.forwardCurveName)) {
            return false;
        }
        return Double.doubleToLongBits(this.timeScaling) == Double.doubleToLongBits(other.timeScaling);
    }
}

