/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.products;

import net.finmath.marketdata2.model.AnalyticModel;
import net.finmath.marketdata2.model.curves.DiscountCurveInterface;
import net.finmath.marketdata2.model.curves.ForwardCurveInterface;
import net.finmath.marketdata2.products.AbstractAnalyticProduct;
import net.finmath.marketdata2.products.AnalyticProduct;
import net.finmath.stochastic.RandomVariable;

public class MarketForwardRateAgreement
extends AbstractAnalyticProduct
implements AnalyticProduct {
    private final double maturity;
    private final double paymentOffset;
    private final String forwardCurveName;
    private final double spread;
    private final String discountCurveName;

    public MarketForwardRateAgreement(double maturity, double paymentOffset, String forwardCurveName, double spread, String discountCurveName) {
        this.maturity = maturity;
        this.paymentOffset = paymentOffset;
        this.forwardCurveName = forwardCurveName;
        this.spread = spread;
        this.discountCurveName = discountCurveName;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AnalyticModel model) {
        ForwardCurveInterface forwardCurve = model.getForwardCurve(this.forwardCurveName);
        DiscountCurveInterface discountCurve = model.getDiscountCurve(this.discountCurveName);
        DiscountCurveInterface discountCurveForForward = null;
        if (forwardCurve == null && this.forwardCurveName != null && this.forwardCurveName.length() > 0 && (discountCurveForForward = model.getDiscountCurve(this.forwardCurveName)) == null) {
            throw new IllegalArgumentException("No curve of the name " + this.forwardCurveName + " was found in the model.");
        }
        RandomVariable forward = model.getRandomVariableForConstant(-this.spread);
        if (forwardCurve != null) {
            forward = forward.add(forwardCurve.getForward(model, this.maturity));
        } else if (discountCurveForForward != null) {
            forward = forward.add(discountCurveForForward.getDiscountFactor(this.maturity).div(discountCurveForForward.getDiscountFactor(this.maturity + this.paymentOffset)).sub(1.0).div(this.paymentOffset));
        }
        RandomVariable payoff = forward.discount(forward, this.paymentOffset);
        RandomVariable discountFactor = this.maturity > evaluationTime ? discountCurve.getDiscountFactor(model, this.maturity) : model.getRandomVariableForConstant(0.0);
        return payoff.mult(discountFactor).div(discountCurve.getDiscountFactor(model, evaluationTime));
    }
}

