/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.products;

import net.finmath.marketdata2.model.AnalyticModel;
import net.finmath.marketdata2.products.AbstractAnalyticProduct;
import net.finmath.marketdata2.products.AnalyticProduct;
import net.finmath.stochastic.RandomVariable;

public class Performance
extends AbstractAnalyticProduct
implements AnalyticProduct {
    private final AbstractAnalyticProduct productNumerator;
    private final AbstractAnalyticProduct productDenominator;

    public Performance(AbstractAnalyticProduct productNumerator, AbstractAnalyticProduct productDenominator) {
        this.productNumerator = productNumerator;
        this.productDenominator = productDenominator;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AnalyticModel model) {
        RandomVariable valueNumerator = this.productNumerator.getValue(evaluationTime, model);
        RandomVariable valueDenominator = this.productDenominator.getValue(evaluationTime, model);
        RandomVariable value = valueNumerator.div(valueDenominator);
        return value;
    }

    public String toString() {
        return "Performance [productNumerator=" + this.productNumerator + ", productDenominator=" + this.productDenominator + "]";
    }
}

