/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.marketdata2.products;

import net.finmath.marketdata2.model.AnalyticModel;
import net.finmath.marketdata2.model.AnalyticModelFromCurvesAndVols;
import net.finmath.marketdata2.model.curves.Curve;
import net.finmath.marketdata2.model.curves.DiscountCurveFromForwardCurve;
import net.finmath.marketdata2.model.curves.DiscountCurveInterface;
import net.finmath.marketdata2.model.curves.ForwardCurveInterface;
import net.finmath.marketdata2.products.AbstractAnalyticProduct;
import net.finmath.marketdata2.products.AnalyticProduct;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.RegularSchedule;
import net.finmath.time.Schedule;
import net.finmath.time.TimeDiscretization;

public class SwapAnnuity
extends AbstractAnalyticProduct
implements AnalyticProduct {
    private final Schedule schedule;
    private final String discountCurveName;

    public SwapAnnuity(Schedule schedule, String discountCurveName) {
        this.schedule = schedule;
        this.discountCurveName = discountCurveName;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, AnalyticModel model) {
        DiscountCurveInterface discountCurve = (DiscountCurveInterface)model.getCurve(this.discountCurveName);
        return SwapAnnuity.getSwapAnnuity(evaluationTime, this.schedule, discountCurve, model);
    }

    public static RandomVariable getSwapAnnuity(TimeDiscretization tenor, DiscountCurveInterface discountCurve) {
        return SwapAnnuity.getSwapAnnuity((Schedule)new RegularSchedule(tenor), discountCurve);
    }

    public static RandomVariable getSwapAnnuity(TimeDiscretization tenor, ForwardCurveInterface forwardCurve) {
        return SwapAnnuity.getSwapAnnuity((Schedule)new RegularSchedule(tenor), forwardCurve);
    }

    public static RandomVariable getSwapAnnuity(Schedule schedule, DiscountCurveInterface discountCurve) {
        double evaluationTime = 0.0;
        return SwapAnnuity.getSwapAnnuity(0.0, schedule, discountCurve, null);
    }

    public static RandomVariable getSwapAnnuity(Schedule schedule, ForwardCurveInterface forwardCurve) {
        DiscountCurveFromForwardCurve discountCurve = new DiscountCurveFromForwardCurve(forwardCurve.getName());
        double evaluationTime = 0.0;
        return SwapAnnuity.getSwapAnnuity(0.0, schedule, discountCurve, new AnalyticModelFromCurvesAndVols(new Curve[]{forwardCurve, discountCurve}));
    }

    public static RandomVariable getSwapAnnuity(double evaluationTime, Schedule schedule, DiscountCurveInterface discountCurve, AnalyticModel model) {
        RandomVariable value = new RandomVariableFromDoubleArray(0.0);
        for (int periodIndex = 0; periodIndex < schedule.getNumberOfPeriods(); ++periodIndex) {
            double paymentDate = schedule.getPayment(periodIndex);
            if (paymentDate <= evaluationTime) continue;
            double periodLength = schedule.getPeriodLength(periodIndex);
            RandomVariable discountFactor = discountCurve.getDiscountFactor(model, paymentDate);
            value = discountFactor.mult(periodLength).add(value);
        }
        return value.div(discountCurve.getDiscountFactor(model, evaluationTime));
    }

    public String toString() {
        return "SwapAnnuity [schedule=" + this.schedule + ", discountCurveName=" + this.discountCurveName + "]";
    }
}

