/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.descriptor;

import java.time.LocalDate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.finmath.marketdata.model.curves.Curve;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.modelling.descriptor.InterestRateModelDescriptor;

public class AnalyticModelDescriptor
implements InterestRateModelDescriptor {
    private final LocalDate referenceDate;
    private final Map<String, Curve> curvesMap;
    private final Map<String, VolatilitySurface> volatilitySurfaceMap;

    public AnalyticModelDescriptor(LocalDate referenceDate, Collection<Curve> curves, Collection<VolatilitySurface> surfaces) {
        this.referenceDate = referenceDate;
        this.curvesMap = new HashMap<String, Curve>();
        this.volatilitySurfaceMap = new HashMap<String, VolatilitySurface>();
        if (curves != null) {
            for (Curve curve : curves) {
                this.curvesMap.put(curve.getName(), curve);
            }
        }
        if (surfaces != null) {
            for (VolatilitySurface surface : surfaces) {
                this.volatilitySurfaceMap.put(surface.getName(), surface);
            }
        }
    }

    public AnalyticModelDescriptor(LocalDate referenceDate, Map<String, Curve> curvesMap, Map<String, VolatilitySurface> volatilitySurfaceMap) {
        this.referenceDate = referenceDate;
        this.curvesMap = new HashMap<String, Curve>();
        this.volatilitySurfaceMap = new HashMap<String, VolatilitySurface>();
        this.curvesMap.putAll(curvesMap);
        this.volatilitySurfaceMap.putAll(volatilitySurfaceMap);
    }

    @Override
    public Integer version() {
        return 1;
    }

    @Override
    public String name() {
        return "Analytic model";
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public Map<String, Curve> getCurvesMap() {
        return Collections.unmodifiableMap(this.curvesMap);
    }

    public Map<String, VolatilitySurface> getVolatilitySurfaceMap() {
        return Collections.unmodifiableMap(this.volatilitySurfaceMap);
    }
}

