/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.descriptor;

import java.util.Arrays;
import net.finmath.modelling.InterestRateProductDescriptor;
import net.finmath.modelling.descriptor.ScheduleDescriptor;

public class InterestRateSwapLegProductDescriptor
implements InterestRateProductDescriptor {
    private static final String productName = "Interest Rate Swap Leg";
    private final String forwardCurveName;
    private final String discountCurveName;
    private final ScheduleDescriptor legSchedule;
    private final double[] notionals;
    private final double[] spreads;
    private final boolean isNotionalExchanged;

    public InterestRateSwapLegProductDescriptor(String forwardCurveName, String discountCurveName, ScheduleDescriptor legSchedule, double notional, double spread, boolean isNotionalExchanged) {
        this.forwardCurveName = forwardCurveName;
        this.discountCurveName = discountCurveName;
        this.legSchedule = legSchedule;
        double[] notionals = new double[legSchedule.getNumberOfPeriods()];
        Arrays.fill(notionals, notional);
        this.notionals = notionals;
        double[] spreads = new double[legSchedule.getNumberOfPeriods()];
        Arrays.fill(spreads, spread);
        this.spreads = spreads;
        this.isNotionalExchanged = isNotionalExchanged;
    }

    public InterestRateSwapLegProductDescriptor(String forwardCurveName, String discountCurveName, ScheduleDescriptor legSchedule, double[] notionals, double[] spreads, boolean isNotionalExchanged) {
        this.forwardCurveName = forwardCurveName;
        this.discountCurveName = discountCurveName;
        this.legSchedule = legSchedule;
        this.notionals = notionals;
        this.spreads = spreads;
        this.isNotionalExchanged = isNotionalExchanged;
    }

    public String getForwardCurveName() {
        return this.forwardCurveName;
    }

    public String getDiscountCurveName() {
        return this.discountCurveName;
    }

    public ScheduleDescriptor getLegScheduleDescriptor() {
        return this.legSchedule;
    }

    public double[] getNotionals() {
        return (double[])this.notionals.clone();
    }

    public double[] getSpreads() {
        return this.spreads;
    }

    public boolean isNotionalExchanged() {
        return this.isNotionalExchanged;
    }

    @Override
    public Integer version() {
        return 1;
    }

    @Override
    public String name() {
        return productName;
    }
}

