/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.descriptor;

import java.time.LocalDate;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.modelling.descriptor.AssetModelDescriptor;

public class VarianceGammaModelDescriptor
implements AssetModelDescriptor {
    private final LocalDate referenceDate;
    private final Double initialValue;
    private final DiscountCurve discountCurveForForwardRate;
    private final DiscountCurve discountCurveForDiscountRate;
    private final double sigma;
    private final double theta;
    private final double nu;

    public VarianceGammaModelDescriptor(LocalDate referenceDate, Double initialValue, DiscountCurve discountCurveForForwardRate, DiscountCurve discountCurveForDiscountRate, double sigma, double theta, double nu) {
        this.referenceDate = referenceDate;
        this.initialValue = initialValue;
        this.discountCurveForForwardRate = discountCurveForForwardRate;
        this.discountCurveForDiscountRate = discountCurveForDiscountRate;
        this.sigma = sigma;
        this.theta = theta;
        this.nu = nu;
    }

    @Override
    public Integer version() {
        return 1;
    }

    @Override
    public String name() {
        return "Single asset Variance Gamma model";
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public Double getInitialValue() {
        return this.initialValue;
    }

    public DiscountCurve getDiscountCurveForForwardRate() {
        return this.discountCurveForForwardRate;
    }

    public DiscountCurve getDiscountCurveForDiscountRate() {
        return this.discountCurveForDiscountRate;
    }

    public double getSigma() {
        return this.sigma;
    }

    public double getTheta() {
        return this.theta;
    }

    public double getNu() {
        return this.nu;
    }
}

