/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.descriptor.xmlparser;

import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.finmath.modelling.ProductDescriptor;
import net.finmath.modelling.descriptor.InterestRateSwapLegProductDescriptor;
import net.finmath.modelling.descriptor.InterestRateSwapProductDescriptor;
import net.finmath.modelling.descriptor.ScheduleDescriptor;
import net.finmath.modelling.descriptor.xmlparser.XMLParser;
import net.finmath.time.ScheduleGenerator;
import net.finmath.time.businessdaycalendar.AbstractBusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingTARGETHolidays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FPMLParser
implements XMLParser {
    private final String homePartyId;
    private final String discountCurveName;
    private final AbstractBusinessdayCalendar abstractBusinessdayCalendar = new BusinessdayCalendarExcludingTARGETHolidays();
    private final ScheduleGenerator.ShortPeriodConvention shortPeriodConvention = ScheduleGenerator.ShortPeriodConvention.LAST;

    public FPMLParser(String homePartyId, String discountCurveName) {
        this.homePartyId = homePartyId;
        this.discountCurveName = discountCurveName;
    }

    @Override
    public ProductDescriptor getProductDescriptor(File file) throws SAXException, IOException, ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        doc.getDocumentElement().normalize();
        if (!doc.getDocumentElement().getNodeName().equalsIgnoreCase("dataDocument")) {
            throw new IllegalArgumentException("This parser is meant for XML of type dataDocument, according to FpML 5, but file is " + doc.getDocumentElement().getNodeName() + ".");
        }
        if (!doc.getDocumentElement().getAttribute("fpmlVersion").split("-")[0].equals("5")) {
            throw new IllegalArgumentException("This parser is meant for FpML of version 5.*, file is version " + doc.getDocumentElement().getAttribute("fpmlVersion"));
        }
        Element trade = null;
        String tradeName = null;
        NodeList tradeWrapper = doc.getElementsByTagName("trade").item(0).getChildNodes();
        for (int index = 0; index < tradeWrapper.getLength(); ++index) {
            if (tradeWrapper.item(index).getNodeType() != 1 || tradeWrapper.item(index).getNodeName().equalsIgnoreCase("tradeHeader")) continue;
            trade = (Element)tradeWrapper.item(index);
            tradeName = trade.getNodeName().toUpperCase();
            break;
        }
        switch (tradeName) {
            case "SWAP": {
                return this.getSwapProductDescriptor(trade);
            }
        }
        throw new IllegalArgumentException("This FpML parser is not set up to process trades of type " + tradeName + ".");
    }

    private ProductDescriptor getSwapProductDescriptor(Element trade) {
        InterestRateSwapLegProductDescriptor legReceiver = null;
        InterestRateSwapLegProductDescriptor legPayer = null;
        NodeList legs = trade.getElementsByTagName("swapStream");
        for (int legIndex = 0; legIndex < legs.getLength(); ++legIndex) {
            Element leg = (Element)legs.item(legIndex);
            boolean isPayer = leg.getElementsByTagName("payerPartyReference").item(0).getAttributes().getNamedItem("href").getNodeValue().equals(this.homePartyId);
            if (isPayer) {
                legPayer = this.getSwapLegProductDescriptor(leg);
                continue;
            }
            legReceiver = this.getSwapLegProductDescriptor(leg);
        }
        return new InterestRateSwapProductDescriptor(legReceiver, legPayer);
    }

    private InterestRateSwapLegProductDescriptor getSwapLegProductDescriptor(Element leg) {
        boolean isFixed = leg.getElementsByTagName("calculationPeriodDates").item(0).getAttributes().getNamedItem("id").getTextContent().equalsIgnoreCase("fixedCalcPeriodDates");
        LocalDate startDate = LocalDate.parse(((Element)leg.getElementsByTagName("effectiveDate").item(0)).getElementsByTagName("unadjustedDate").item(0).getTextContent());
        LocalDate maturityDate = LocalDate.parse(((Element)leg.getElementsByTagName("terminationDate").item(0)).getElementsByTagName("unadjustedDate").item(0).getTextContent());
        int fixingOffsetDays = 0;
        if (leg.getElementsByTagName("fixingDates").getLength() > 0) {
            fixingOffsetDays = Integer.parseInt(((Element)leg.getElementsByTagName("fixingDates").item(0)).getElementsByTagName("periodMultiplier").item(0).getTextContent());
        }
        int paymentOffsetDays = 0;
        if (leg.getElementsByTagName("paymentDaysOffset").getLength() > 0) {
            paymentOffsetDays = Integer.parseInt(((Element)leg.getElementsByTagName("paymentDaysOffset").item(0)).getElementsByTagName("periodMultiplier").item(0).getTextContent());
        }
        String xmlInput = ((Element)leg.getElementsByTagName("calculationPeriodDatesAdjustments").item(0)).getElementsByTagName("businessDayConvention").item(0).getTextContent();
        xmlInput = xmlInput.replaceAll("ING", "");
        BusinessdayCalendar.DateRollConvention dateRollConvention = BusinessdayCalendar.DateRollConvention.getEnum(xmlInput);
        ScheduleGenerator.DaycountConvention daycountConvention = ScheduleGenerator.DaycountConvention.getEnum(leg.getElementsByTagName("dayCountFraction").item(0).getTextContent());
        ScheduleGenerator.Frequency frequency = null;
        Element calcNode = (Element)leg.getElementsByTagName("calculationPeriodFrequency").item(0);
        int multiplier = Integer.parseInt(calcNode.getElementsByTagName("periodMultiplier").item(0).getTextContent());
        switch (calcNode.getElementsByTagName("period").item(0).getTextContent().toUpperCase()) {
            case "D": {
                if (multiplier != 1) break;
                frequency = ScheduleGenerator.Frequency.DAILY;
                break;
            }
            case "Y": {
                if (multiplier != 1) break;
                frequency = ScheduleGenerator.Frequency.ANNUAL;
                break;
            }
            case "M": {
                switch (multiplier) {
                    case 1: {
                        frequency = ScheduleGenerator.Frequency.MONTHLY;
                    }
                    case 3: {
                        frequency = ScheduleGenerator.Frequency.QUARTERLY;
                    }
                    case 6: {
                        frequency = ScheduleGenerator.Frequency.SEMIANNUAL;
                    }
                }
                throw new IllegalArgumentException("Unknown period " + calcNode.getElementsByTagName("period").item(0).getTextContent() + ".");
            }
            default: {
                throw new IllegalArgumentException("Unknown period " + calcNode.getElementsByTagName("period").item(0).getTextContent() + ".");
            }
        }
        ScheduleDescriptor schedule = new ScheduleDescriptor(startDate, maturityDate, frequency, daycountConvention, this.shortPeriodConvention, dateRollConvention, this.abstractBusinessdayCalendar, fixingOffsetDays, paymentOffsetDays);
        double notional = Double.parseDouble(((Element)leg.getElementsByTagName("notionalSchedule").item(0)).getElementsByTagName("initialValue").item(0).getTextContent());
        double spread = 0.0;
        String forwardCurveName = "";
        if (isFixed) {
            spread = Double.parseDouble(((Element)leg.getElementsByTagName("fixedRateSchedule").item(0)).getElementsByTagName("initialValue").item(0).getTextContent());
        } else {
            forwardCurveName = leg.getElementsByTagName("floatingRateIndex").item(0).getTextContent();
        }
        return new InterestRateSwapLegProductDescriptor(forwardCurveName, this.discountCurveName, schedule, notional, spread, false);
    }
}

