/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.modelfactory;

import net.finmath.modelling.DescribedModel;
import net.finmath.modelling.DescribedProduct;
import net.finmath.modelling.ModelFactory;
import net.finmath.modelling.ProductDescriptor;
import net.finmath.modelling.descriptor.AssetModelDescriptor;
import net.finmath.modelling.descriptor.BlackScholesModelDescriptor;
import net.finmath.modelling.descriptor.HestonModelDescriptor;
import net.finmath.modelling.descriptor.MertonModelDescriptor;
import net.finmath.modelling.descriptor.VarianceGammaModelDescriptor;
import net.finmath.modelling.productfactory.SingleAssetMonteCarloProductFactory;
import net.finmath.montecarlo.IndependentIncrements;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.RandomVariableFromArrayFactory;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloAssetModel;
import net.finmath.montecarlo.assetderivativevaluation.models.BlackScholesModelWithCurves;
import net.finmath.montecarlo.assetderivativevaluation.models.HestonModel;
import net.finmath.montecarlo.assetderivativevaluation.models.MertonModel;
import net.finmath.montecarlo.assetderivativevaluation.models.VarianceGammaModel;
import net.finmath.montecarlo.model.ProcessModel;

public class AssetModelMonteCarloFactory
implements ModelFactory<AssetModelDescriptor> {
    private final HestonModel.Scheme scheme;
    private final RandomVariableFactory randomVariableFactory;
    private final IndependentIncrements stochasticDriver;

    public AssetModelMonteCarloFactory(RandomVariableFactory randomVariableFactory, IndependentIncrements stochasticDriver, HestonModel.Scheme scheme) {
        this.scheme = scheme;
        this.randomVariableFactory = randomVariableFactory;
        this.stochasticDriver = stochasticDriver;
    }

    public AssetModelMonteCarloFactory(RandomVariableFactory randomVariableFactory, IndependentIncrements stochasticDriver) {
        this.scheme = null;
        this.randomVariableFactory = randomVariableFactory;
        this.stochasticDriver = stochasticDriver;
    }

    public AssetModelMonteCarloFactory(IndependentIncrements stochasticDriver) {
        this.scheme = null;
        this.randomVariableFactory = new RandomVariableFromArrayFactory();
        this.stochasticDriver = stochasticDriver;
    }

    @Override
    public DescribedModel<? extends AssetModelDescriptor> getModelFromDescriptor(AssetModelDescriptor descriptor) {
        if (descriptor instanceof BlackScholesModelDescriptor) {
            BlackScholesModelMonteCarlo model = new BlackScholesModelMonteCarlo((BlackScholesModelDescriptor)descriptor, this.randomVariableFactory, this.stochasticDriver);
            return model;
        }
        if (descriptor instanceof HestonModelDescriptor) {
            if (this.scheme == null) {
                throw new RuntimeException("Need to provide truncation scheme to factory in order to be able to build a Heston Model");
            }
            HestonModelMonteCarlo model = new HestonModelMonteCarlo((HestonModelDescriptor)descriptor, this.scheme, this.randomVariableFactory, this.stochasticDriver);
            return model;
        }
        if (descriptor instanceof MertonModelDescriptor) {
            MertonModelMonteCarlo model = new MertonModelMonteCarlo((MertonModelDescriptor)descriptor, this.randomVariableFactory, this.stochasticDriver);
            return model;
        }
        if (descriptor instanceof VarianceGammaModelDescriptor) {
            VarianceGammaModelMonteCarlo model = new VarianceGammaModelMonteCarlo((VarianceGammaModelDescriptor)descriptor, this.stochasticDriver);
            return model;
        }
        String name = descriptor.name();
        throw new IllegalArgumentException("Unsupported product type " + name);
    }

    private static class VarianceGammaModelMonteCarlo
    extends MonteCarloAssetModel
    implements DescribedModel<VarianceGammaModelDescriptor> {
        private final VarianceGammaModelDescriptor descriptor;
        private final SingleAssetMonteCarloProductFactory productFactory;

        private VarianceGammaModelMonteCarlo(VarianceGammaModelDescriptor descriptor, IndependentIncrements stochasticDriver) {
            super((ProcessModel)new VarianceGammaModel(descriptor), stochasticDriver);
            this.descriptor = descriptor;
            this.productFactory = new SingleAssetMonteCarloProductFactory(descriptor.getReferenceDate());
        }

        @Override
        public VarianceGammaModelDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public DescribedProduct<? extends ProductDescriptor> getProductFromDescriptor(ProductDescriptor productDescriptor) {
            return this.productFactory.getProductFromDescriptor(productDescriptor);
        }
    }

    private static class MertonModelMonteCarlo
    extends MonteCarloAssetModel
    implements DescribedModel<MertonModelDescriptor> {
        private final MertonModelDescriptor descriptor;
        private final SingleAssetMonteCarloProductFactory productFactory;

        private MertonModelMonteCarlo(MertonModelDescriptor descriptor, RandomVariableFactory randomVariableFactory, IndependentIncrements stochasticDriver) {
            super((ProcessModel)new MertonModel(descriptor), stochasticDriver);
            this.descriptor = descriptor;
            this.productFactory = new SingleAssetMonteCarloProductFactory(descriptor.getReferenceDate());
        }

        @Override
        public MertonModelDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public DescribedProduct<? extends ProductDescriptor> getProductFromDescriptor(ProductDescriptor productDescriptor) {
            return this.productFactory.getProductFromDescriptor(productDescriptor);
        }
    }

    private static class HestonModelMonteCarlo
    extends MonteCarloAssetModel
    implements DescribedModel<HestonModelDescriptor> {
        private final HestonModelDescriptor descriptor;
        private final SingleAssetMonteCarloProductFactory productFactory;

        private HestonModelMonteCarlo(HestonModelDescriptor descriptor, HestonModel.Scheme scheme, RandomVariableFactory randomVariableFactory, IndependentIncrements stochasticDriver) {
            super((ProcessModel)new HestonModel(descriptor, scheme, randomVariableFactory), stochasticDriver);
            this.descriptor = descriptor;
            this.productFactory = new SingleAssetMonteCarloProductFactory(descriptor.getReferenceDate());
        }

        @Override
        public HestonModelDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public DescribedProduct<? extends ProductDescriptor> getProductFromDescriptor(ProductDescriptor productDescriptor) {
            return this.productFactory.getProductFromDescriptor(productDescriptor);
        }
    }

    private static class BlackScholesModelMonteCarlo
    extends MonteCarloAssetModel
    implements DescribedModel<BlackScholesModelDescriptor> {
        private final BlackScholesModelDescriptor descriptor;
        private final SingleAssetMonteCarloProductFactory productFactory;

        private BlackScholesModelMonteCarlo(BlackScholesModelDescriptor descriptor, RandomVariableFactory randomVariableFactory, IndependentIncrements stochasticDriver) {
            super((ProcessModel)new BlackScholesModelWithCurves(descriptor.getInitialValue(), descriptor.getDiscountCurveForForwardRate(), descriptor.getVolatility(), descriptor.getDiscountCurveForDiscountRate(), randomVariableFactory), stochasticDriver);
            this.descriptor = descriptor;
            this.productFactory = new SingleAssetMonteCarloProductFactory(descriptor.getReferenceDate());
        }

        @Override
        public BlackScholesModelDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public DescribedProduct<? extends ProductDescriptor> getProductFromDescriptor(ProductDescriptor productDescriptor) {
            return this.productFactory.getProductFromDescriptor(productDescriptor);
        }
    }
}

