/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.modelling.modelfactory;

import net.finmath.modelling.DescribedModel;
import net.finmath.modelling.DescribedProduct;
import net.finmath.modelling.ModelFactory;
import net.finmath.modelling.ProductDescriptor;
import net.finmath.modelling.SingleAssetProductDescriptor;
import net.finmath.modelling.descriptor.BlackScholesModelDescriptor;
import net.finmath.modelling.productfactory.SingleAssetMonteCarloProductFactory;
import net.finmath.montecarlo.IndependentIncrements;
import net.finmath.montecarlo.RandomVariableFactory;
import net.finmath.montecarlo.assetderivativevaluation.MonteCarloAssetModel;
import net.finmath.montecarlo.assetderivativevaluation.models.BlackScholesModelWithCurves;
import net.finmath.montecarlo.model.ProcessModel;
import net.finmath.montecarlo.process.EulerSchemeFromProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;

public class BlackScholesModelMonteCarloFactory
implements ModelFactory<BlackScholesModelDescriptor> {
    private final RandomVariableFactory randomVariableFactory;
    private final IndependentIncrements brownianMotion;

    public BlackScholesModelMonteCarloFactory(RandomVariableFactory randomVariableFactory, IndependentIncrements brownianMotion) {
        this.randomVariableFactory = randomVariableFactory;
        this.brownianMotion = brownianMotion;
    }

    @Override
    public DescribedModel<BlackScholesModelDescriptor> getModelFromDescriptor(final BlackScholesModelDescriptor modelDescriptor) {
        BlackScholesModelWithCurves model = new BlackScholesModelWithCurves(modelDescriptor.getInitialValue(), modelDescriptor.getDiscountCurveForForwardRate(), modelDescriptor.getVolatility(), modelDescriptor.getDiscountCurveForDiscountRate(), this.randomVariableFactory);
        class BlackScholesMonteCarloModel
        extends MonteCarloAssetModel
        implements DescribedModel<BlackScholesModelDescriptor> {
            private final SingleAssetMonteCarloProductFactory productFactory;

            BlackScholesMonteCarloModel(ProcessModel model, MonteCarloProcess process) {
                super(model, process);
                this.productFactory = new SingleAssetMonteCarloProductFactory(modelDescriptor.getReferenceDate());
            }

            @Override
            public BlackScholesModelDescriptor getDescriptor() {
                return modelDescriptor;
            }

            @Override
            public DescribedProduct<? extends ProductDescriptor> getProductFromDescriptor(ProductDescriptor productDescriptor) {
                if (productDescriptor instanceof SingleAssetProductDescriptor) {
                    return this.productFactory.getProductFromDescriptor(productDescriptor);
                }
                String name = modelDescriptor.name();
                throw new IllegalArgumentException("Unsupported product type " + name);
            }
        }
        return new BlackScholesMonteCarloModel(model, new EulerSchemeFromProcessModel(model, this.brownianMotion));
    }
}

